## TFSA-2022-054: Stack overflow due to self-recursive function in `GraphDef`

### CVE Number
CVE-2022-23591

### Impact
The `GraphDef` format in TensorFlow does not allow self recursive functions. The runtime assumes that this invariant is satisfied. However, a `GraphDef` containing a fragment such as the following can be consumed when loading a `SavedModel`:

```
  library {
    function {
      signature {
        name: "SomeOp"
        description: "Self recursive op"
      }
      node_def {
        name: "1"
        op: "SomeOp"
      }
      node_def {
        name: "2"
        op: "SomeOp"
      }
    }
  }
```

This would result in a stack overflow during execution as resolving each `NodeDef` means resolving the function itself and its nodes.

### Patches
We have patched the issue in GitHub commit [448a16182065bd08a202d9057dd8ca541e67996c](https://github.com/tensorflow/tensorflow/commit/448a16182065bd08a202d9057dd8ca541e67996c).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
