; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=mipsel   -mcpu=mips32              -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS32,MIPS32-EL %s
; RUN: llc -march=mips     -mcpu=mips32              -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS32,MIPS32-EB %s
; RUN: llc -march=mipsel   -mcpu=mips32r2            -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS32,MIPS32-EL %s
; RUN: llc -march=mips     -mcpu=mips32r2            -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS32,MIPS32-EB %s
; RUN: llc -march=mipsel   -mcpu=mips32r6            -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS32R6,MIPS32R6-EL %s
; RUN: llc -march=mips     -mcpu=mips32r6            -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS32R6,MIPS32R6-EB %s
; RUN: llc -march=mips64el -mcpu=mips4    -target-abi=n64 -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS64,MIPS64-EL %s
; RUN: llc -march=mips64   -mcpu=mips4    -target-abi=n64 -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS64,MIPS64-EB %s
; RUN: llc -march=mips64el -mcpu=mips64   -target-abi=n64 -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS64,MIPS64-EL %s
; RUN: llc -march=mips64   -mcpu=mips64   -target-abi=n64 -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS64,MIPS64-EB %s
; RUN: llc -march=mips64el -mcpu=mips64r2 -target-abi=n64 -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS64,MIPS64R2-EL %s
; RUN: llc -march=mips64   -mcpu=mips64r2 -target-abi=n64 -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS64,MIPS64R2-EB %s
; RUN: llc -march=mips64el -mcpu=mips64r6 -target-abi=n64 -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS64R6 %s
; RUN: llc -march=mips64   -mcpu=mips64r6 -target-abi=n64 -relocation-model=pic < %s | FileCheck -check-prefixes=MIPS64R6 %s

%struct.SLL = type { i64 }
%struct.SI = type { i32 }
%struct.SUI = type { i32 }

@sll = common global %struct.SLL zeroinitializer, align 1
@si = common global %struct.SI zeroinitializer, align 1
@sui = common global %struct.SUI zeroinitializer, align 1

define i32 @load_SI() nounwind readonly {
; MIPS32-EL-LABEL: load_SI:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addu $1, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(si)($1)
; MIPS32-EL-NEXT:    lwl $2, 3($1)
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    lwr $2, 0($1)
;
; MIPS32-EB-LABEL: load_SI:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addu $1, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(si)($1)
; MIPS32-EB-NEXT:    lwl $2, 0($1)
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    lwr $2, 3($1)
;
; MIPS32R6-LABEL: load_SI:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-NEXT:    addu $1, $2, $25
; MIPS32R6-NEXT:    lw $1, %got(si)($1)
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    lw $2, 0($1)
;
; MIPS64-EL-LABEL: load_SI:
; MIPS64-EL:       # %bb.0: # %entry
; MIPS64-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SI)))
; MIPS64-EL-NEXT:    daddu $1, $1, $25
; MIPS64-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SI)))
; MIPS64-EL-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64-EL-NEXT:    lwl $2, 3($1)
; MIPS64-EL-NEXT:    jr $ra
; MIPS64-EL-NEXT:    lwr $2, 0($1)
;
; MIPS64-EB-LABEL: load_SI:
; MIPS64-EB:       # %bb.0: # %entry
; MIPS64-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SI)))
; MIPS64-EB-NEXT:    daddu $1, $1, $25
; MIPS64-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SI)))
; MIPS64-EB-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64-EB-NEXT:    lwl $2, 0($1)
; MIPS64-EB-NEXT:    jr $ra
; MIPS64-EB-NEXT:    lwr $2, 3($1)
;
; MIPS64R2-EL-LABEL: load_SI:
; MIPS64R2-EL:       # %bb.0: # %entry
; MIPS64R2-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SI)))
; MIPS64R2-EL-NEXT:    daddu $1, $1, $25
; MIPS64R2-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SI)))
; MIPS64R2-EL-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R2-EL-NEXT:    lwl $2, 3($1)
; MIPS64R2-EL-NEXT:    jr $ra
; MIPS64R2-EL-NEXT:    lwr $2, 0($1)
;
; MIPS64R2-EB-LABEL: load_SI:
; MIPS64R2-EB:       # %bb.0: # %entry
; MIPS64R2-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SI)))
; MIPS64R2-EB-NEXT:    daddu $1, $1, $25
; MIPS64R2-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SI)))
; MIPS64R2-EB-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R2-EB-NEXT:    lwl $2, 0($1)
; MIPS64R2-EB-NEXT:    jr $ra
; MIPS64R2-EB-NEXT:    lwr $2, 3($1)
;
; MIPS64R6-LABEL: load_SI:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SI)))
; MIPS64R6-NEXT:    daddu $1, $1, $25
; MIPS64R6-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SI)))
; MIPS64R6-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    lw $2, 0($1)
entry:
  %0 = load i32, ptr @si, align 1
  ret i32 %0
}

define void @store_SI(i32 signext %a) nounwind {
; MIPS32-EL-LABEL: store_SI:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addu $1, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(si)($1)
; MIPS32-EL-NEXT:    swl $4, 3($1)
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    swr $4, 0($1)
;
; MIPS32-EB-LABEL: store_SI:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addu $1, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(si)($1)
; MIPS32-EB-NEXT:    swl $4, 0($1)
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    swr $4, 3($1)
;
; MIPS32R6-LABEL: store_SI:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-NEXT:    addu $1, $2, $25
; MIPS32R6-NEXT:    lw $1, %got(si)($1)
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    sw $4, 0($1)
;
; MIPS64-EL-LABEL: store_SI:
; MIPS64-EL:       # %bb.0: # %entry
; MIPS64-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SI)))
; MIPS64-EL-NEXT:    daddu $1, $1, $25
; MIPS64-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SI)))
; MIPS64-EL-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64-EL-NEXT:    swl $4, 3($1)
; MIPS64-EL-NEXT:    jr $ra
; MIPS64-EL-NEXT:    swr $4, 0($1)
;
; MIPS64-EB-LABEL: store_SI:
; MIPS64-EB:       # %bb.0: # %entry
; MIPS64-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SI)))
; MIPS64-EB-NEXT:    daddu $1, $1, $25
; MIPS64-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SI)))
; MIPS64-EB-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64-EB-NEXT:    swl $4, 0($1)
; MIPS64-EB-NEXT:    jr $ra
; MIPS64-EB-NEXT:    swr $4, 3($1)
;
; MIPS64R2-EL-LABEL: store_SI:
; MIPS64R2-EL:       # %bb.0: # %entry
; MIPS64R2-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SI)))
; MIPS64R2-EL-NEXT:    daddu $1, $1, $25
; MIPS64R2-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SI)))
; MIPS64R2-EL-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R2-EL-NEXT:    swl $4, 3($1)
; MIPS64R2-EL-NEXT:    jr $ra
; MIPS64R2-EL-NEXT:    swr $4, 0($1)
;
; MIPS64R2-EB-LABEL: store_SI:
; MIPS64R2-EB:       # %bb.0: # %entry
; MIPS64R2-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SI)))
; MIPS64R2-EB-NEXT:    daddu $1, $1, $25
; MIPS64R2-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SI)))
; MIPS64R2-EB-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R2-EB-NEXT:    swl $4, 0($1)
; MIPS64R2-EB-NEXT:    jr $ra
; MIPS64R2-EB-NEXT:    swr $4, 3($1)
;
; MIPS64R6-LABEL: store_SI:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SI)))
; MIPS64R6-NEXT:    daddu $1, $1, $25
; MIPS64R6-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SI)))
; MIPS64R6-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    sw $4, 0($1)
entry:
  store i32 %a, ptr @si, align 1
  ret void
}

define i64 @load_SLL() nounwind readonly {
; MIPS32-EL-LABEL: load_SLL:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addu $1, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(sll)($1)
; MIPS32-EL-NEXT:    lwl $2, 3($1)
; MIPS32-EL-NEXT:    lwr $2, 0($1)
; MIPS32-EL-NEXT:    lwl $3, 7($1)
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    lwr $3, 4($1)
;
; MIPS32-EB-LABEL: load_SLL:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addu $1, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(sll)($1)
; MIPS32-EB-NEXT:    lwl $2, 0($1)
; MIPS32-EB-NEXT:    lwr $2, 3($1)
; MIPS32-EB-NEXT:    lwl $3, 4($1)
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    lwr $3, 7($1)
;
; MIPS32R6-LABEL: load_SLL:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-NEXT:    addu $1, $2, $25
; MIPS32R6-NEXT:    lw $1, %got(sll)($1)
; MIPS32R6-NEXT:    lw $2, 0($1)
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    lw $3, 4($1)
;
; MIPS64-EL-LABEL: load_SLL:
; MIPS64-EL:       # %bb.0: # %entry
; MIPS64-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SLL)))
; MIPS64-EL-NEXT:    daddu $1, $1, $25
; MIPS64-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SLL)))
; MIPS64-EL-NEXT:    ld $1, %got_disp(sll)($1)
; MIPS64-EL-NEXT:    ldl $2, 7($1)
; MIPS64-EL-NEXT:    jr $ra
; MIPS64-EL-NEXT:    ldr $2, 0($1)
;
; MIPS64-EB-LABEL: load_SLL:
; MIPS64-EB:       # %bb.0: # %entry
; MIPS64-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SLL)))
; MIPS64-EB-NEXT:    daddu $1, $1, $25
; MIPS64-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SLL)))
; MIPS64-EB-NEXT:    ld $1, %got_disp(sll)($1)
; MIPS64-EB-NEXT:    ldl $2, 0($1)
; MIPS64-EB-NEXT:    jr $ra
; MIPS64-EB-NEXT:    ldr $2, 7($1)
;
; MIPS64R2-EL-LABEL: load_SLL:
; MIPS64R2-EL:       # %bb.0: # %entry
; MIPS64R2-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SLL)))
; MIPS64R2-EL-NEXT:    daddu $1, $1, $25
; MIPS64R2-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SLL)))
; MIPS64R2-EL-NEXT:    ld $1, %got_disp(sll)($1)
; MIPS64R2-EL-NEXT:    ldl $2, 7($1)
; MIPS64R2-EL-NEXT:    jr $ra
; MIPS64R2-EL-NEXT:    ldr $2, 0($1)
;
; MIPS64R2-EB-LABEL: load_SLL:
; MIPS64R2-EB:       # %bb.0: # %entry
; MIPS64R2-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SLL)))
; MIPS64R2-EB-NEXT:    daddu $1, $1, $25
; MIPS64R2-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SLL)))
; MIPS64R2-EB-NEXT:    ld $1, %got_disp(sll)($1)
; MIPS64R2-EB-NEXT:    ldl $2, 0($1)
; MIPS64R2-EB-NEXT:    jr $ra
; MIPS64R2-EB-NEXT:    ldr $2, 7($1)
;
; MIPS64R6-LABEL: load_SLL:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SLL)))
; MIPS64R6-NEXT:    daddu $1, $1, $25
; MIPS64R6-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SLL)))
; MIPS64R6-NEXT:    ld $1, %got_disp(sll)($1)
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    ld $2, 0($1)
entry:
  %0 = load i64, ptr @sll, align 1
  ret i64 %0
}

define i64 @load_SI_sext_to_i64() nounwind readonly {
; MIPS32-EL-LABEL: load_SI_sext_to_i64:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addu $1, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(si)($1)
; MIPS32-EL-NEXT:    lwl $2, 3($1)
; MIPS32-EL-NEXT:    lwr $2, 0($1)
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    sra $3, $2, 31
;
; MIPS32-EB-LABEL: load_SI_sext_to_i64:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addu $1, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(si)($1)
; MIPS32-EB-NEXT:    lwl $3, 0($1)
; MIPS32-EB-NEXT:    lwr $3, 3($1)
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    sra $2, $3, 31
;
; MIPS32R6-EL-LABEL: load_SI_sext_to_i64:
; MIPS32R6-EL:       # %bb.0: # %entry
; MIPS32R6-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-EL-NEXT:    addu $1, $2, $25
; MIPS32R6-EL-NEXT:    lw $1, %got(si)($1)
; MIPS32R6-EL-NEXT:    lw $2, 0($1)
; MIPS32R6-EL-NEXT:    jr $ra
; MIPS32R6-EL-NEXT:    sra $3, $2, 31
;
; MIPS32R6-EB-LABEL: load_SI_sext_to_i64:
; MIPS32R6-EB:       # %bb.0: # %entry
; MIPS32R6-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-EB-NEXT:    addu $1, $2, $25
; MIPS32R6-EB-NEXT:    lw $1, %got(si)($1)
; MIPS32R6-EB-NEXT:    lw $3, 0($1)
; MIPS32R6-EB-NEXT:    jr $ra
; MIPS32R6-EB-NEXT:    sra $2, $3, 31
;
; MIPS64-EL-LABEL: load_SI_sext_to_i64:
; MIPS64-EL:       # %bb.0: # %entry
; MIPS64-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SI_sext_to_i64)))
; MIPS64-EL-NEXT:    daddu $1, $1, $25
; MIPS64-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SI_sext_to_i64)))
; MIPS64-EL-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64-EL-NEXT:    lwl $2, 3($1)
; MIPS64-EL-NEXT:    jr $ra
; MIPS64-EL-NEXT:    lwr $2, 0($1)
;
; MIPS64-EB-LABEL: load_SI_sext_to_i64:
; MIPS64-EB:       # %bb.0: # %entry
; MIPS64-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SI_sext_to_i64)))
; MIPS64-EB-NEXT:    daddu $1, $1, $25
; MIPS64-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SI_sext_to_i64)))
; MIPS64-EB-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64-EB-NEXT:    lwl $2, 0($1)
; MIPS64-EB-NEXT:    jr $ra
; MIPS64-EB-NEXT:    lwr $2, 3($1)
;
; MIPS64R2-EL-LABEL: load_SI_sext_to_i64:
; MIPS64R2-EL:       # %bb.0: # %entry
; MIPS64R2-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SI_sext_to_i64)))
; MIPS64R2-EL-NEXT:    daddu $1, $1, $25
; MIPS64R2-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SI_sext_to_i64)))
; MIPS64R2-EL-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R2-EL-NEXT:    lwl $2, 3($1)
; MIPS64R2-EL-NEXT:    jr $ra
; MIPS64R2-EL-NEXT:    lwr $2, 0($1)
;
; MIPS64R2-EB-LABEL: load_SI_sext_to_i64:
; MIPS64R2-EB:       # %bb.0: # %entry
; MIPS64R2-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SI_sext_to_i64)))
; MIPS64R2-EB-NEXT:    daddu $1, $1, $25
; MIPS64R2-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SI_sext_to_i64)))
; MIPS64R2-EB-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R2-EB-NEXT:    lwl $2, 0($1)
; MIPS64R2-EB-NEXT:    jr $ra
; MIPS64R2-EB-NEXT:    lwr $2, 3($1)
;
; MIPS64R6-LABEL: load_SI_sext_to_i64:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %hi(%neg(%gp_rel(load_SI_sext_to_i64)))
; MIPS64R6-NEXT:    daddu $1, $1, $25
; MIPS64R6-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_SI_sext_to_i64)))
; MIPS64R6-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    lw $2, 0($1)
entry:
  %0 = load i32, ptr @si, align 1
  %conv = sext i32 %0 to i64
  ret i64 %conv
}

define i64 @load_UI() nounwind readonly {
; MIPS32-EL-LABEL: load_UI:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addu $1, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(sui)($1)
; MIPS32-EL-NEXT:    lwl $2, 3($1)
; MIPS32-EL-NEXT:    lwr $2, 0($1)
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    addiu $3, $zero, 0
;
; MIPS32-EB-LABEL: load_UI:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addu $1, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(sui)($1)
; MIPS32-EB-NEXT:    lwl $3, 0($1)
; MIPS32-EB-NEXT:    lwr $3, 3($1)
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    addiu $2, $zero, 0
;
; MIPS32R6-EL-LABEL: load_UI:
; MIPS32R6-EL:       # %bb.0: # %entry
; MIPS32R6-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-EL-NEXT:    addu $1, $2, $25
; MIPS32R6-EL-NEXT:    lw $1, %got(sui)($1)
; MIPS32R6-EL-NEXT:    lw $2, 0($1)
; MIPS32R6-EL-NEXT:    jr $ra
; MIPS32R6-EL-NEXT:    addiu $3, $zero, 0
;
; MIPS32R6-EB-LABEL: load_UI:
; MIPS32R6-EB:       # %bb.0: # %entry
; MIPS32R6-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-EB-NEXT:    addu $1, $2, $25
; MIPS32R6-EB-NEXT:    lw $1, %got(sui)($1)
; MIPS32R6-EB-NEXT:    lw $3, 0($1)
; MIPS32R6-EB-NEXT:    jr $ra
; MIPS32R6-EB-NEXT:    addiu $2, $zero, 0
;
; MIPS64-EL-LABEL: load_UI:
; MIPS64-EL:       # %bb.0: # %entry
; MIPS64-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(load_UI)))
; MIPS64-EL-NEXT:    daddu $1, $1, $25
; MIPS64-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_UI)))
; MIPS64-EL-NEXT:    ld $1, %got_disp(sui)($1)
; MIPS64-EL-NEXT:    lwl $2, 3($1)
; MIPS64-EL-NEXT:    lwr $2, 0($1)
; MIPS64-EL-NEXT:    daddiu $1, $zero, 1
; MIPS64-EL-NEXT:    dsll $1, $1, 32
; MIPS64-EL-NEXT:    daddiu $1, $1, -1
; MIPS64-EL-NEXT:    jr $ra
; MIPS64-EL-NEXT:    and $2, $2, $1
;
; MIPS64-EB-LABEL: load_UI:
; MIPS64-EB:       # %bb.0: # %entry
; MIPS64-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(load_UI)))
; MIPS64-EB-NEXT:    daddu $1, $1, $25
; MIPS64-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_UI)))
; MIPS64-EB-NEXT:    ld $1, %got_disp(sui)($1)
; MIPS64-EB-NEXT:    lwl $2, 0($1)
; MIPS64-EB-NEXT:    lwr $2, 3($1)
; MIPS64-EB-NEXT:    daddiu $1, $zero, 1
; MIPS64-EB-NEXT:    dsll $1, $1, 32
; MIPS64-EB-NEXT:    daddiu $1, $1, -1
; MIPS64-EB-NEXT:    jr $ra
; MIPS64-EB-NEXT:    and $2, $2, $1
;
; MIPS64R2-EL-LABEL: load_UI:
; MIPS64R2-EL:       # %bb.0: # %entry
; MIPS64R2-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(load_UI)))
; MIPS64R2-EL-NEXT:    daddu $1, $1, $25
; MIPS64R2-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_UI)))
; MIPS64R2-EL-NEXT:    ld $1, %got_disp(sui)($1)
; MIPS64R2-EL-NEXT:    lwl $2, 3($1)
; MIPS64R2-EL-NEXT:    lwr $2, 0($1)
; MIPS64R2-EL-NEXT:    jr $ra
; MIPS64R2-EL-NEXT:    dext $2, $2, 0, 32
;
; MIPS64R2-EB-LABEL: load_UI:
; MIPS64R2-EB:       # %bb.0: # %entry
; MIPS64R2-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(load_UI)))
; MIPS64R2-EB-NEXT:    daddu $1, $1, $25
; MIPS64R2-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_UI)))
; MIPS64R2-EB-NEXT:    ld $1, %got_disp(sui)($1)
; MIPS64R2-EB-NEXT:    lwl $2, 0($1)
; MIPS64R2-EB-NEXT:    lwr $2, 3($1)
; MIPS64R2-EB-NEXT:    jr $ra
; MIPS64R2-EB-NEXT:    dext $2, $2, 0, 32
;
; MIPS64R6-LABEL: load_UI:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %hi(%neg(%gp_rel(load_UI)))
; MIPS64R6-NEXT:    daddu $1, $1, $25
; MIPS64R6-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(load_UI)))
; MIPS64R6-NEXT:    ld $1, %got_disp(sui)($1)
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    lwu $2, 0($1)
entry:
  %0 = load i32, ptr @sui, align 1
  %conv = zext i32 %0 to i64
  ret i64 %conv
}

define void @store_SLL(i64 %a) nounwind {
; MIPS32-EL-LABEL: store_SLL:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addu $1, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(sll)($1)
; MIPS32-EL-NEXT:    swl $5, 7($1)
; MIPS32-EL-NEXT:    swl $4, 3($1)
; MIPS32-EL-NEXT:    swr $5, 4($1)
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    swr $4, 0($1)
;
; MIPS32-EB-LABEL: store_SLL:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addu $1, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(sll)($1)
; MIPS32-EB-NEXT:    swl $5, 4($1)
; MIPS32-EB-NEXT:    swl $4, 0($1)
; MIPS32-EB-NEXT:    swr $5, 7($1)
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    swr $4, 3($1)
;
; MIPS32R6-LABEL: store_SLL:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-NEXT:    addu $1, $2, $25
; MIPS32R6-NEXT:    lw $1, %got(sll)($1)
; MIPS32R6-NEXT:    sw $5, 4($1)
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    sw $4, 0($1)
;
; MIPS64-EL-LABEL: store_SLL:
; MIPS64-EL:       # %bb.0: # %entry
; MIPS64-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SLL)))
; MIPS64-EL-NEXT:    daddu $1, $1, $25
; MIPS64-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SLL)))
; MIPS64-EL-NEXT:    ld $1, %got_disp(sll)($1)
; MIPS64-EL-NEXT:    sdl $4, 7($1)
; MIPS64-EL-NEXT:    jr $ra
; MIPS64-EL-NEXT:    sdr $4, 0($1)
;
; MIPS64-EB-LABEL: store_SLL:
; MIPS64-EB:       # %bb.0: # %entry
; MIPS64-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SLL)))
; MIPS64-EB-NEXT:    daddu $1, $1, $25
; MIPS64-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SLL)))
; MIPS64-EB-NEXT:    ld $1, %got_disp(sll)($1)
; MIPS64-EB-NEXT:    sdl $4, 0($1)
; MIPS64-EB-NEXT:    jr $ra
; MIPS64-EB-NEXT:    sdr $4, 7($1)
;
; MIPS64R2-EL-LABEL: store_SLL:
; MIPS64R2-EL:       # %bb.0: # %entry
; MIPS64R2-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SLL)))
; MIPS64R2-EL-NEXT:    daddu $1, $1, $25
; MIPS64R2-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SLL)))
; MIPS64R2-EL-NEXT:    ld $1, %got_disp(sll)($1)
; MIPS64R2-EL-NEXT:    sdl $4, 7($1)
; MIPS64R2-EL-NEXT:    jr $ra
; MIPS64R2-EL-NEXT:    sdr $4, 0($1)
;
; MIPS64R2-EB-LABEL: store_SLL:
; MIPS64R2-EB:       # %bb.0: # %entry
; MIPS64R2-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SLL)))
; MIPS64R2-EB-NEXT:    daddu $1, $1, $25
; MIPS64R2-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SLL)))
; MIPS64R2-EB-NEXT:    ld $1, %got_disp(sll)($1)
; MIPS64R2-EB-NEXT:    sdl $4, 0($1)
; MIPS64R2-EB-NEXT:    jr $ra
; MIPS64R2-EB-NEXT:    sdr $4, 7($1)
;
; MIPS64R6-LABEL: store_SLL:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SLL)))
; MIPS64R6-NEXT:    daddu $1, $1, $25
; MIPS64R6-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SLL)))
; MIPS64R6-NEXT:    ld $1, %got_disp(sll)($1)
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    sd $4, 0($1)
entry:
  store i64 %a, ptr @sll, align 1
  ret void
}

define void @store_SI_trunc_from_i64(i32 signext %a) nounwind {
; MIPS32-EL-LABEL: store_SI_trunc_from_i64:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addu $1, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(si)($1)
; MIPS32-EL-NEXT:    swl $4, 3($1)
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    swr $4, 0($1)
;
; MIPS32-EB-LABEL: store_SI_trunc_from_i64:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addu $1, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(si)($1)
; MIPS32-EB-NEXT:    swl $4, 0($1)
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    swr $4, 3($1)
;
; MIPS32R6-LABEL: store_SI_trunc_from_i64:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-NEXT:    addu $1, $2, $25
; MIPS32R6-NEXT:    lw $1, %got(si)($1)
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    sw $4, 0($1)
;
; MIPS64-EL-LABEL: store_SI_trunc_from_i64:
; MIPS64-EL:       # %bb.0: # %entry
; MIPS64-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SI_trunc_from_i64)))
; MIPS64-EL-NEXT:    daddu $1, $1, $25
; MIPS64-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SI_trunc_from_i64)))
; MIPS64-EL-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64-EL-NEXT:    swl $4, 3($1)
; MIPS64-EL-NEXT:    jr $ra
; MIPS64-EL-NEXT:    swr $4, 0($1)
;
; MIPS64-EB-LABEL: store_SI_trunc_from_i64:
; MIPS64-EB:       # %bb.0: # %entry
; MIPS64-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SI_trunc_from_i64)))
; MIPS64-EB-NEXT:    daddu $1, $1, $25
; MIPS64-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SI_trunc_from_i64)))
; MIPS64-EB-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64-EB-NEXT:    swl $4, 0($1)
; MIPS64-EB-NEXT:    jr $ra
; MIPS64-EB-NEXT:    swr $4, 3($1)
;
; MIPS64R2-EL-LABEL: store_SI_trunc_from_i64:
; MIPS64R2-EL:       # %bb.0: # %entry
; MIPS64R2-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SI_trunc_from_i64)))
; MIPS64R2-EL-NEXT:    daddu $1, $1, $25
; MIPS64R2-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SI_trunc_from_i64)))
; MIPS64R2-EL-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R2-EL-NEXT:    swl $4, 3($1)
; MIPS64R2-EL-NEXT:    jr $ra
; MIPS64R2-EL-NEXT:    swr $4, 0($1)
;
; MIPS64R2-EB-LABEL: store_SI_trunc_from_i64:
; MIPS64R2-EB:       # %bb.0: # %entry
; MIPS64R2-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SI_trunc_from_i64)))
; MIPS64R2-EB-NEXT:    daddu $1, $1, $25
; MIPS64R2-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SI_trunc_from_i64)))
; MIPS64R2-EB-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R2-EB-NEXT:    swl $4, 0($1)
; MIPS64R2-EB-NEXT:    jr $ra
; MIPS64R2-EB-NEXT:    swr $4, 3($1)
;
; MIPS64R6-LABEL: store_SI_trunc_from_i64:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %hi(%neg(%gp_rel(store_SI_trunc_from_i64)))
; MIPS64R6-NEXT:    daddu $1, $1, $25
; MIPS64R6-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(store_SI_trunc_from_i64)))
; MIPS64R6-NEXT:    ld $1, %got_disp(si)($1)
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    sw $4, 0($1)
entry:
  store i32 %a, ptr @si, align 1
  ret void
}

;
; Structures are simply concatenations of the members. They are unaffected by
; endianness
;

%struct.S0 = type { i8, i8 }
@struct_s0 = common global %struct.S0 zeroinitializer, align 1
%struct.S1 = type { i16, i16 }
@struct_s1 = common global %struct.S1 zeroinitializer, align 1
%struct.S2 = type { i32, i32 }
@struct_s2 = common global %struct.S2 zeroinitializer, align 1

define void @copy_struct_S0() nounwind {
; MIPS32-LABEL: copy_struct_S0:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(struct_s0)($1)
; MIPS32-NEXT:    lbu $2, 0($1)
; MIPS32-NEXT:    sb $2, 2($1)
; MIPS32-NEXT:    lbu $2, 1($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    sb $2, 3($1)
;
; MIPS32R6-LABEL: copy_struct_S0:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-NEXT:    addu $1, $2, $25
; MIPS32R6-NEXT:    lw $1, %got(struct_s0)($1)
; MIPS32R6-NEXT:    lhu $2, 0($1)
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    sh $2, 2($1)
;
; MIPS64-LABEL: copy_struct_S0:
; MIPS64:       # %bb.0: # %entry
; MIPS64-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S0)))
; MIPS64-NEXT:    daddu $1, $1, $25
; MIPS64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S0)))
; MIPS64-NEXT:    ld $1, %got_disp(struct_s0)($1)
; MIPS64-NEXT:    lbu $2, 0($1)
; MIPS64-NEXT:    sb $2, 2($1)
; MIPS64-NEXT:    lbu $2, 1($1)
; MIPS64-NEXT:    jr $ra
; MIPS64-NEXT:    sb $2, 3($1)
;
; MIPS64R6-LABEL: copy_struct_S0:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S0)))
; MIPS64R6-NEXT:    daddu $1, $1, $25
; MIPS64R6-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S0)))
; MIPS64R6-NEXT:    ld $1, %got_disp(struct_s0)($1)
; MIPS64R6-NEXT:    lhu $2, 0($1)
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    sh $2, 2($1)
entry:
  %0 = load %struct.S0, ptr @struct_s0, align 1
  store %struct.S0 %0, ptr getelementptr inbounds (%struct.S0, ptr @struct_s0, i32 1), align 1
  ret void
}

define void @copy_struct_S1() nounwind {
; MIPS32-EL-LABEL: copy_struct_S1:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addu $1, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(struct_s1)($1)
; MIPS32-EL-NEXT:    lwl $2, 3($1)
; MIPS32-EL-NEXT:    lwr $2, 0($1)
; MIPS32-EL-NEXT:    swl $2, 7($1)
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    swr $2, 4($1)
;
; MIPS32-EB-LABEL: copy_struct_S1:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addu $1, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(struct_s1)($1)
; MIPS32-EB-NEXT:    lwl $2, 0($1)
; MIPS32-EB-NEXT:    lwr $2, 3($1)
; MIPS32-EB-NEXT:    swl $2, 4($1)
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    swr $2, 7($1)
;
; MIPS32R6-LABEL: copy_struct_S1:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-NEXT:    addu $1, $2, $25
; MIPS32R6-NEXT:    lw $1, %got(struct_s1)($1)
; MIPS32R6-NEXT:    lw $2, 0($1)
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    sw $2, 4($1)
;
; MIPS64-EL-LABEL: copy_struct_S1:
; MIPS64-EL:       # %bb.0: # %entry
; MIPS64-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S1)))
; MIPS64-EL-NEXT:    daddu $1, $1, $25
; MIPS64-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S1)))
; MIPS64-EL-NEXT:    ld $1, %got_disp(struct_s1)($1)
; MIPS64-EL-NEXT:    lwl $2, 3($1)
; MIPS64-EL-NEXT:    lwr $2, 0($1)
; MIPS64-EL-NEXT:    swl $2, 7($1)
; MIPS64-EL-NEXT:    jr $ra
; MIPS64-EL-NEXT:    swr $2, 4($1)
;
; MIPS64-EB-LABEL: copy_struct_S1:
; MIPS64-EB:       # %bb.0: # %entry
; MIPS64-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S1)))
; MIPS64-EB-NEXT:    daddu $1, $1, $25
; MIPS64-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S1)))
; MIPS64-EB-NEXT:    ld $1, %got_disp(struct_s1)($1)
; MIPS64-EB-NEXT:    lwl $2, 0($1)
; MIPS64-EB-NEXT:    lwr $2, 3($1)
; MIPS64-EB-NEXT:    swl $2, 4($1)
; MIPS64-EB-NEXT:    jr $ra
; MIPS64-EB-NEXT:    swr $2, 7($1)
;
; MIPS64R2-EL-LABEL: copy_struct_S1:
; MIPS64R2-EL:       # %bb.0: # %entry
; MIPS64R2-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S1)))
; MIPS64R2-EL-NEXT:    daddu $1, $1, $25
; MIPS64R2-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S1)))
; MIPS64R2-EL-NEXT:    ld $1, %got_disp(struct_s1)($1)
; MIPS64R2-EL-NEXT:    lwl $2, 3($1)
; MIPS64R2-EL-NEXT:    lwr $2, 0($1)
; MIPS64R2-EL-NEXT:    swl $2, 7($1)
; MIPS64R2-EL-NEXT:    jr $ra
; MIPS64R2-EL-NEXT:    swr $2, 4($1)
;
; MIPS64R2-EB-LABEL: copy_struct_S1:
; MIPS64R2-EB:       # %bb.0: # %entry
; MIPS64R2-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S1)))
; MIPS64R2-EB-NEXT:    daddu $1, $1, $25
; MIPS64R2-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S1)))
; MIPS64R2-EB-NEXT:    ld $1, %got_disp(struct_s1)($1)
; MIPS64R2-EB-NEXT:    lwl $2, 0($1)
; MIPS64R2-EB-NEXT:    lwr $2, 3($1)
; MIPS64R2-EB-NEXT:    swl $2, 4($1)
; MIPS64R2-EB-NEXT:    jr $ra
; MIPS64R2-EB-NEXT:    swr $2, 7($1)
;
; MIPS64R6-LABEL: copy_struct_S1:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S1)))
; MIPS64R6-NEXT:    daddu $1, $1, $25
; MIPS64R6-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S1)))
; MIPS64R6-NEXT:    ld $1, %got_disp(struct_s1)($1)
; MIPS64R6-NEXT:    lw $2, 0($1)
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    sw $2, 4($1)
entry:
  %0 = load %struct.S1, ptr @struct_s1, align 1
  store %struct.S1 %0, ptr getelementptr inbounds (%struct.S1, ptr @struct_s1, i32 1), align 1
  ret void
}

define void @copy_struct_S2() nounwind {
; MIPS32-EL-LABEL: copy_struct_S2:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addu $1, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(struct_s2)($1)
; MIPS32-EL-NEXT:    lwl $2, 3($1)
; MIPS32-EL-NEXT:    lwr $2, 0($1)
; MIPS32-EL-NEXT:    swl $2, 11($1)
; MIPS32-EL-NEXT:    lwl $3, 7($1)
; MIPS32-EL-NEXT:    lwr $3, 4($1)
; MIPS32-EL-NEXT:    swl $3, 15($1)
; MIPS32-EL-NEXT:    swr $2, 8($1)
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    swr $3, 12($1)
;
; MIPS32-EB-LABEL: copy_struct_S2:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addu $1, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(struct_s2)($1)
; MIPS32-EB-NEXT:    lwl $2, 0($1)
; MIPS32-EB-NEXT:    lwr $2, 3($1)
; MIPS32-EB-NEXT:    swl $2, 8($1)
; MIPS32-EB-NEXT:    lwl $3, 4($1)
; MIPS32-EB-NEXT:    lwr $3, 7($1)
; MIPS32-EB-NEXT:    swl $3, 12($1)
; MIPS32-EB-NEXT:    swr $2, 11($1)
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    swr $3, 15($1)
;
; MIPS32R6-LABEL: copy_struct_S2:
; MIPS32R6:       # %bb.0: # %entry
; MIPS32R6-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-NEXT:    addu $1, $2, $25
; MIPS32R6-NEXT:    lw $1, %got(struct_s2)($1)
; MIPS32R6-NEXT:    lw $2, 0($1)
; MIPS32R6-NEXT:    sw $2, 8($1)
; MIPS32R6-NEXT:    lw $2, 4($1)
; MIPS32R6-NEXT:    jr $ra
; MIPS32R6-NEXT:    sw $2, 12($1)
;
; MIPS64-EL-LABEL: copy_struct_S2:
; MIPS64-EL:       # %bb.0: # %entry
; MIPS64-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S2)))
; MIPS64-EL-NEXT:    daddu $1, $1, $25
; MIPS64-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S2)))
; MIPS64-EL-NEXT:    ld $1, %got_disp(struct_s2)($1)
; MIPS64-EL-NEXT:    ldl $2, 7($1)
; MIPS64-EL-NEXT:    ldr $2, 0($1)
; MIPS64-EL-NEXT:    sdl $2, 15($1)
; MIPS64-EL-NEXT:    jr $ra
; MIPS64-EL-NEXT:    sdr $2, 8($1)
;
; MIPS64-EB-LABEL: copy_struct_S2:
; MIPS64-EB:       # %bb.0: # %entry
; MIPS64-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S2)))
; MIPS64-EB-NEXT:    daddu $1, $1, $25
; MIPS64-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S2)))
; MIPS64-EB-NEXT:    ld $1, %got_disp(struct_s2)($1)
; MIPS64-EB-NEXT:    ldl $2, 0($1)
; MIPS64-EB-NEXT:    ldr $2, 7($1)
; MIPS64-EB-NEXT:    sdl $2, 8($1)
; MIPS64-EB-NEXT:    jr $ra
; MIPS64-EB-NEXT:    sdr $2, 15($1)
;
; MIPS64R2-EL-LABEL: copy_struct_S2:
; MIPS64R2-EL:       # %bb.0: # %entry
; MIPS64R2-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S2)))
; MIPS64R2-EL-NEXT:    daddu $1, $1, $25
; MIPS64R2-EL-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S2)))
; MIPS64R2-EL-NEXT:    ld $1, %got_disp(struct_s2)($1)
; MIPS64R2-EL-NEXT:    ldl $2, 7($1)
; MIPS64R2-EL-NEXT:    ldr $2, 0($1)
; MIPS64R2-EL-NEXT:    sdl $2, 15($1)
; MIPS64R2-EL-NEXT:    jr $ra
; MIPS64R2-EL-NEXT:    sdr $2, 8($1)
;
; MIPS64R2-EB-LABEL: copy_struct_S2:
; MIPS64R2-EB:       # %bb.0: # %entry
; MIPS64R2-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S2)))
; MIPS64R2-EB-NEXT:    daddu $1, $1, $25
; MIPS64R2-EB-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S2)))
; MIPS64R2-EB-NEXT:    ld $1, %got_disp(struct_s2)($1)
; MIPS64R2-EB-NEXT:    ldl $2, 0($1)
; MIPS64R2-EB-NEXT:    ldr $2, 7($1)
; MIPS64R2-EB-NEXT:    sdl $2, 8($1)
; MIPS64R2-EB-NEXT:    jr $ra
; MIPS64R2-EB-NEXT:    sdr $2, 15($1)
;
; MIPS64R6-LABEL: copy_struct_S2:
; MIPS64R6:       # %bb.0: # %entry
; MIPS64R6-NEXT:    lui $1, %hi(%neg(%gp_rel(copy_struct_S2)))
; MIPS64R6-NEXT:    daddu $1, $1, $25
; MIPS64R6-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(copy_struct_S2)))
; MIPS64R6-NEXT:    ld $1, %got_disp(struct_s2)($1)
; MIPS64R6-NEXT:    ld $2, 0($1)
; MIPS64R6-NEXT:    jr $ra
; MIPS64R6-NEXT:    sd $2, 8($1)
entry:
  %0 = load %struct.S2, ptr @struct_s2, align 1
  store %struct.S2 %0, ptr getelementptr inbounds (%struct.S2, ptr @struct_s2, i32 1), align 1
  ret void
}

;
; Arrays are simply concatenations of the members. They are unaffected by
; endianness
;

@arr = common global [7 x i8] zeroinitializer, align 1

define void @pass_array_byval() nounwind {
; MIPS32-EL-LABEL: pass_array_byval:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addiu $sp, $sp, -24
; MIPS32-EL-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-EL-NEXT:    addu $gp, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(arr)($gp)
; MIPS32-EL-NEXT:    lwl $4, 3($1)
; MIPS32-EL-NEXT:    lwr $4, 0($1)
; MIPS32-EL-NEXT:    lbu $2, 4($1)
; MIPS32-EL-NEXT:    lbu $3, 5($1)
; MIPS32-EL-NEXT:    sll $3, $3, 8
; MIPS32-EL-NEXT:    or $2, $3, $2
; MIPS32-EL-NEXT:    lbu $1, 6($1)
; MIPS32-EL-NEXT:    sll $1, $1, 16
; MIPS32-EL-NEXT:    lw $25, %call16(extern_func)($gp)
; MIPS32-EL-NEXT:    .reloc ($tmp0), R_MIPS_JALR, extern_func
; MIPS32-EL-NEXT:  $tmp0:
; MIPS32-EL-NEXT:    jalr $25
; MIPS32-EL-NEXT:    or $5, $2, $1
; MIPS32-EL-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    addiu $sp, $sp, 24
;
; MIPS32-EB-LABEL: pass_array_byval:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addiu $sp, $sp, -24
; MIPS32-EB-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-EB-NEXT:    addu $gp, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(arr)($gp)
; MIPS32-EB-NEXT:    lwl $4, 0($1)
; MIPS32-EB-NEXT:    lbu $2, 5($1)
; MIPS32-EB-NEXT:    lwr $4, 3($1)
; MIPS32-EB-NEXT:    sll $2, $2, 16
; MIPS32-EB-NEXT:    lbu $3, 4($1)
; MIPS32-EB-NEXT:    sll $3, $3, 24
; MIPS32-EB-NEXT:    or $2, $3, $2
; MIPS32-EB-NEXT:    lbu $1, 6($1)
; MIPS32-EB-NEXT:    sll $1, $1, 8
; MIPS32-EB-NEXT:    lw $25, %call16(extern_func)($gp)
; MIPS32-EB-NEXT:    .reloc ($tmp0), R_MIPS_JALR, extern_func
; MIPS32-EB-NEXT:  $tmp0:
; MIPS32-EB-NEXT:    jalr $25
; MIPS32-EB-NEXT:    or $5, $2, $1
; MIPS32-EB-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    addiu $sp, $sp, 24
;
; MIPS32R6-EL-LABEL: pass_array_byval:
; MIPS32R6-EL:       # %bb.0: # %entry
; MIPS32R6-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-EL-NEXT:    addiu $sp, $sp, -24
; MIPS32R6-EL-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32R6-EL-NEXT:    addu $gp, $2, $25
; MIPS32R6-EL-NEXT:    lw $1, %got(arr)($gp)
; MIPS32R6-EL-NEXT:    lhu $2, 4($1)
; MIPS32R6-EL-NEXT:    lbu $3, 6($1)
; MIPS32R6-EL-NEXT:    sll $3, $3, 16
; MIPS32R6-EL-NEXT:    lw $4, 0($1)
; MIPS32R6-EL-NEXT:    lw $25, %call16(extern_func)($gp)
; MIPS32R6-EL-NEXT:    .reloc ($tmp0), R_MIPS_JALR, extern_func
; MIPS32R6-EL-NEXT:  $tmp0:
; MIPS32R6-EL-NEXT:    jalr $25
; MIPS32R6-EL-NEXT:    or $5, $2, $3
; MIPS32R6-EL-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32R6-EL-NEXT:    jr $ra
; MIPS32R6-EL-NEXT:    addiu $sp, $sp, 24
;
; MIPS32R6-EB-LABEL: pass_array_byval:
; MIPS32R6-EB:       # %bb.0: # %entry
; MIPS32R6-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-EB-NEXT:    addiu $sp, $sp, -24
; MIPS32R6-EB-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32R6-EB-NEXT:    addu $gp, $2, $25
; MIPS32R6-EB-NEXT:    lw $1, %got(arr)($gp)
; MIPS32R6-EB-NEXT:    lbu $2, 6($1)
; MIPS32R6-EB-NEXT:    sll $2, $2, 8
; MIPS32R6-EB-NEXT:    lhu $3, 4($1)
; MIPS32R6-EB-NEXT:    sll $3, $3, 16
; MIPS32R6-EB-NEXT:    lw $4, 0($1)
; MIPS32R6-EB-NEXT:    lw $25, %call16(extern_func)($gp)
; MIPS32R6-EB-NEXT:    .reloc ($tmp0), R_MIPS_JALR, extern_func
; MIPS32R6-EB-NEXT:  $tmp0:
; MIPS32R6-EB-NEXT:    jalr $25
; MIPS32R6-EB-NEXT:    or $5, $3, $2
; MIPS32R6-EB-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32R6-EB-NEXT:    jr $ra
; MIPS32R6-EB-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-EL-LABEL: pass_array_byval:
; MIPS64-EL:       # %bb.0: # %entry
; MIPS64-EL-NEXT:    daddiu $sp, $sp, -16
; MIPS64-EL-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64-EL-NEXT:    sd $gp, 0($sp) # 8-byte Folded Spill
; MIPS64-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(pass_array_byval)))
; MIPS64-EL-NEXT:    daddu $1, $1, $25
; MIPS64-EL-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(pass_array_byval)))
; MIPS64-EL-NEXT:    ld $1, %got_disp(arr)($gp)
; MIPS64-EL-NEXT:    lbu $2, 4($1)
; MIPS64-EL-NEXT:    dsll $2, $2, 32
; MIPS64-EL-NEXT:    lbu $3, 5($1)
; MIPS64-EL-NEXT:    dsll $3, $3, 40
; MIPS64-EL-NEXT:    or $2, $3, $2
; MIPS64-EL-NEXT:    lwl $3, 3($1)
; MIPS64-EL-NEXT:    lwr $3, 0($1)
; MIPS64-EL-NEXT:    daddiu $4, $zero, 1
; MIPS64-EL-NEXT:    dsll $4, $4, 32
; MIPS64-EL-NEXT:    daddiu $4, $4, -1
; MIPS64-EL-NEXT:    and $3, $3, $4
; MIPS64-EL-NEXT:    or $2, $3, $2
; MIPS64-EL-NEXT:    lbu $1, 6($1)
; MIPS64-EL-NEXT:    dsll $1, $1, 48
; MIPS64-EL-NEXT:    ld $25, %call16(extern_func)($gp)
; MIPS64-EL-NEXT:    .reloc .Ltmp0, R_MIPS_JALR, extern_func
; MIPS64-EL-NEXT:  .Ltmp0:
; MIPS64-EL-NEXT:    jalr $25
; MIPS64-EL-NEXT:    or $4, $2, $1
; MIPS64-EL-NEXT:    ld $gp, 0($sp) # 8-byte Folded Reload
; MIPS64-EL-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64-EL-NEXT:    jr $ra
; MIPS64-EL-NEXT:    daddiu $sp, $sp, 16
;
; MIPS64-EB-LABEL: pass_array_byval:
; MIPS64-EB:       # %bb.0: # %entry
; MIPS64-EB-NEXT:    daddiu $sp, $sp, -16
; MIPS64-EB-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64-EB-NEXT:    sd $gp, 0($sp) # 8-byte Folded Spill
; MIPS64-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(pass_array_byval)))
; MIPS64-EB-NEXT:    daddu $1, $1, $25
; MIPS64-EB-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(pass_array_byval)))
; MIPS64-EB-NEXT:    ld $1, %got_disp(arr)($gp)
; MIPS64-EB-NEXT:    lbu $2, 5($1)
; MIPS64-EB-NEXT:    dsll $2, $2, 16
; MIPS64-EB-NEXT:    lbu $3, 4($1)
; MIPS64-EB-NEXT:    dsll $3, $3, 24
; MIPS64-EB-NEXT:    or $2, $3, $2
; MIPS64-EB-NEXT:    lwl $3, 0($1)
; MIPS64-EB-NEXT:    lwr $3, 3($1)
; MIPS64-EB-NEXT:    dsll $3, $3, 32
; MIPS64-EB-NEXT:    or $2, $3, $2
; MIPS64-EB-NEXT:    lbu $1, 6($1)
; MIPS64-EB-NEXT:    dsll $1, $1, 8
; MIPS64-EB-NEXT:    ld $25, %call16(extern_func)($gp)
; MIPS64-EB-NEXT:    .reloc .Ltmp0, R_MIPS_JALR, extern_func
; MIPS64-EB-NEXT:  .Ltmp0:
; MIPS64-EB-NEXT:    jalr $25
; MIPS64-EB-NEXT:    or $4, $2, $1
; MIPS64-EB-NEXT:    ld $gp, 0($sp) # 8-byte Folded Reload
; MIPS64-EB-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64-EB-NEXT:    jr $ra
; MIPS64-EB-NEXT:    daddiu $sp, $sp, 16
;
; MIPS64R2-EL-LABEL: pass_array_byval:
; MIPS64R2-EL:       # %bb.0: # %entry
; MIPS64R2-EL-NEXT:    daddiu $sp, $sp, -16
; MIPS64R2-EL-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64R2-EL-NEXT:    sd $gp, 0($sp) # 8-byte Folded Spill
; MIPS64R2-EL-NEXT:    lui $1, %hi(%neg(%gp_rel(pass_array_byval)))
; MIPS64R2-EL-NEXT:    daddu $1, $1, $25
; MIPS64R2-EL-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(pass_array_byval)))
; MIPS64R2-EL-NEXT:    ld $1, %got_disp(arr)($gp)
; MIPS64R2-EL-NEXT:    lbu $2, 4($1)
; MIPS64R2-EL-NEXT:    dsll $2, $2, 32
; MIPS64R2-EL-NEXT:    lbu $3, 5($1)
; MIPS64R2-EL-NEXT:    dsll $3, $3, 40
; MIPS64R2-EL-NEXT:    or $2, $3, $2
; MIPS64R2-EL-NEXT:    lwl $3, 3($1)
; MIPS64R2-EL-NEXT:    lwr $3, 0($1)
; MIPS64R2-EL-NEXT:    dext $3, $3, 0, 32
; MIPS64R2-EL-NEXT:    or $2, $3, $2
; MIPS64R2-EL-NEXT:    lbu $1, 6($1)
; MIPS64R2-EL-NEXT:    dsll $1, $1, 48
; MIPS64R2-EL-NEXT:    ld $25, %call16(extern_func)($gp)
; MIPS64R2-EL-NEXT:    .reloc .Ltmp0, R_MIPS_JALR, extern_func
; MIPS64R2-EL-NEXT:  .Ltmp0:
; MIPS64R2-EL-NEXT:    jalr $25
; MIPS64R2-EL-NEXT:    or $4, $2, $1
; MIPS64R2-EL-NEXT:    ld $gp, 0($sp) # 8-byte Folded Reload
; MIPS64R2-EL-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64R2-EL-NEXT:    jr $ra
; MIPS64R2-EL-NEXT:    daddiu $sp, $sp, 16
;
; MIPS64R2-EB-LABEL: pass_array_byval:
; MIPS64R2-EB:       # %bb.0: # %entry
; MIPS64R2-EB-NEXT:    daddiu $sp, $sp, -16
; MIPS64R2-EB-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; MIPS64R2-EB-NEXT:    sd $gp, 0($sp) # 8-byte Folded Spill
; MIPS64R2-EB-NEXT:    lui $1, %hi(%neg(%gp_rel(pass_array_byval)))
; MIPS64R2-EB-NEXT:    daddu $1, $1, $25
; MIPS64R2-EB-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(pass_array_byval)))
; MIPS64R2-EB-NEXT:    ld $1, %got_disp(arr)($gp)
; MIPS64R2-EB-NEXT:    lbu $2, 5($1)
; MIPS64R2-EB-NEXT:    dsll $2, $2, 16
; MIPS64R2-EB-NEXT:    lbu $3, 4($1)
; MIPS64R2-EB-NEXT:    dsll $3, $3, 24
; MIPS64R2-EB-NEXT:    or $2, $3, $2
; MIPS64R2-EB-NEXT:    lwl $3, 0($1)
; MIPS64R2-EB-NEXT:    lwr $3, 3($1)
; MIPS64R2-EB-NEXT:    dext $3, $3, 0, 32
; MIPS64R2-EB-NEXT:    dsll $3, $3, 32
; MIPS64R2-EB-NEXT:    or $2, $3, $2
; MIPS64R2-EB-NEXT:    lbu $1, 6($1)
; MIPS64R2-EB-NEXT:    dsll $1, $1, 8
; MIPS64R2-EB-NEXT:    ld $25, %call16(extern_func)($gp)
; MIPS64R2-EB-NEXT:    .reloc .Ltmp0, R_MIPS_JALR, extern_func
; MIPS64R2-EB-NEXT:  .Ltmp0:
; MIPS64R2-EB-NEXT:    jalr $25
; MIPS64R2-EB-NEXT:    or $4, $2, $1
; MIPS64R2-EB-NEXT:    ld $gp, 0($sp) # 8-byte Folded Reload
; MIPS64R2-EB-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; MIPS64R2-EB-NEXT:    jr $ra
; MIPS64R2-EB-NEXT:    daddiu $sp, $sp, 16
entry:
  tail call void @extern_func(ptr byval([7 x i8]) @arr) nounwind
  ret void
}

declare void @extern_func(ptr byval([7 x i8]))
