# 2021-04-01 Triage Log

A somewhat negative weak for performance where regressions outweigh improvements. Sadly, a lot of the regressions don't seem very straight-forward to understand, and so more investigation will be necessary.

Triage done by **@rylev**.
Revision range: [9b6339e4b9747d473270baa42e77e1d2fff39bf4..4896450e7e0a522486b4d3a8d360ac4e1d2072a0](https://perf.rust-lang.org/?start=9b6339e4b9747d473270baa42e77e1d2fff39bf4&end=4896450e7e0a522486b4d3a8d360ac4e1d2072a0&absolute=false&stat=instructions%3Au)

2 Regressions, 2 Improvements, 3 Mixed
2 of them in rollups

#### Regressions

implement `feature(const_generics_defaults)` [#75384](https://github.com/rust-lang/rust/issues/75384)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=db492ecd5ba6bd82205612cebb9034710653f0c2&end=5b33de3340c7b36646af46303a30f7066b4bd7db&stat=instructions:u) (up to 1.1% on `incr-unchanged` builds of `ucd-check`)
- A small regression in incremental compilation in one particular benchmark `ucd`. The query affected is `generate_crate_metadata` which tracks with the fact that incremental compilation is affected.
- A quick scan of the changes doesn't reveal anything suspicious as encoding of metadata has changed only a little bit and should only be impacted when encoding something with default const generics.

Use `EvaluatedToOkModuloRegions` whenever we erase regions [#83220](https://github.com/rust-lang/rust/issues/83220)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=f5fe425c925ef36d5f4c18cfa44173fc42de31b8&end=07e0e2ec268c140e607e1ac7f49f145612d0f597&stat=instructions:u) (up to 1.8% on `full` builds of `hyper-2-check`)
- A moderate regression in trait obligation evaluation which this code directly impacts. 
- A performance run was performed, but the impact was deemed acceptable. The author and reviewer [were pinged](https://github.com/rust-lang/rust/pull/83220#issuecomment-811752366) about why the performance is acceptable.

Refactor `Binder` to track bound vars [#76814](https://github.com/rust-lang/rust/issues/76814)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a5029ac0ab372aec515db2e718da6d7787f3d122&end=4fdac23f3171e2f8864d359a21da600dd3faafc9&stat=instructions:u) (up to 3.9% on `incr-unchanged` builds of `externs-check`)
- Moderate regression in trait resolution queries which this code directly impacts. While a performance run was made, it was never discussed in the PR. The author and reviewer [were pinged](https://github.com/rust-lang/rust/pull/76814#issuecomment-811758311).

#### Improvements

Rollup of 9 pull requests [#83432](https://github.com/rust-lang/rust/issues/83432)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=673d0db5e393e9c64897005b470bfeb6d5aec61b&end=db492ecd5ba6bd82205612cebb9034710653f0c2&stat=instructions:u) (up to -4.2% on `full` builds of `html5ever-opt`)

Rollup of 8 pull requests [#83580](https://github.com/rust-lang/rust/issues/83580)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=afaf33dcafe9c7068b63eb997df221aa08db7c29&end=9b0edb7fddacd6a60a380c1ce59159de597ab270&stat=instructions:u) (up to -1.4% on `full` builds of `html5ever-opt`)

#### Mixed

Remove assignments to ZST places instead of marking ZST return place as unused [#83177](https://github.com/rust-lang/rust/issues/83177)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=4eb0bc7346ef38218e21268001a898f6892db2c1&end=79e5814f4520f2c51b5307421db45cd82d134e76&stat=instructions:u) (up to 3.1% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo-debug`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=4eb0bc7346ef38218e21268001a898f6892db2c1&end=79e5814f4520f2c51b5307421db45cd82d134e76&stat=instructions:u) (up to -1.1% on `incr-full` builds of `externs-debug`)
- Perf regression is mainly in LLVM caused most likely by LLVM now being able to perf optimizations it could not previously. It's unclear why the regression occurred though.

Import small cold functions [#82980](https://github.com/rust-lang/rust/issues/82980)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=4137088d9da94f693b287f35e2b17782c0b1a283&end=e423058751a2b098d3e469a8e6df1b7a8bbd67b6&stat=instructions:u) (up to 4.7% on `incr-unchanged` builds of `deeply-nested-async-check`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=4137088d9da94f693b287f35e2b17782c0b1a283&end=e423058751a2b098d3e469a8e6df1b7a8bbd67b6&stat=instructions:u) (up to -2.3% on `full` builds of `ctfe-stress-4-opt`)
- I am unsure of the overall cost/benefit analysis of this change and have [pinged](https://github.com/rust-lang/rust/pull/82980#issuecomment-811767001) the author and reviewer about it.

Reduce the impact of Vec::reserve calls that do not cause any allocation [#83357](https://github.com/rust-lang/rust/issues/83357)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=902ca44c1953ad8f640e86d154c86cc1f5a3bde1&end=32d3276561e88bfdf92cc483cff842a24fdd4b37&stat=instructions:u) (up to 3.1% on `incr-unchanged` builds of `webrender-wrench-opt`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=902ca44c1953ad8f640e86d154c86cc1f5a3bde1&end=32d3276561e88bfdf92cc483cff842a24fdd4b37&stat=instructions:u) (up to -2.2% on `incr-unchanged` builds of `ucd-check`)
- It is often hard to track how changes in the standard library impact performance. The author and reviewer were [pinged](https://github.com/rust-lang/rust/pull/83357#issuecomment-811770400) for their perspective.

#### Nags requiring follow up

- The [issue](https://github.com/rust-lang/rust/pull/82964#issuecomment-800663588) from two weeks ago has stalled.
- Follow-ups from this week:
    - https://github.com/rust-lang/rust/pull/83220#issuecomment-811752366
    - https://github.com/rust-lang/rust/pull/76814#issuecomment-811758311
    - https://github.com/rust-lang/rust/pull/82980#issuecomment-811767001
    - https://github.com/rust-lang/rust/pull/83357#issuecomment-811770400