use Test2::V0;
use Test2::Tools::Command;

use FindBin qw($Bin);

plan 4;

local @Test2::Tools::Command::command = ( $ENV{'RSASS'} || 'rsass' );

subtest 'options or arguments' => sub {
	command {
		stderr => qr{^error: the following required arguments were not},
		status => 2,
	};
};

subtest 'help option' => sub {
	command {
		args   => ['--help'],
		stdout => qr{Usage: rsass},
	};
};

subtest 'version option' => sub {
	command {
		args   => ['--version'],
		stdout => qr{rsass-cli},
	};
};

my $css = do { local $/; open my $fh, '<', "$Bin/test.css" or die $!; <$fh> };

subtest 'parse' => sub {
	command {
		args  => ["$Bin/test.scss"],
		stdout => $css,
	};
};

done_testing;
