% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tk2dialogs.R
\name{tk2chooseFont}
\alias{tk2chooseFont}
\alias{tk2unicode_config}
\alias{tk2unicode_select}
\alias{tk2unicode_bind}
\title{Additional Tk dialog boxes}
\usage{
tk2chooseFont(...)

tk2unicode_config(parent)

tk2unicode_select(widget)

tk2unicode_bind(widget)
}
\arguments{
\item{...}{Further arguments passed to the dialog box.}

\item{parent}{The Tk toplevel dialog box that will be the parent of the
configuration dialog box.}

\item{widget}{A widget that can accept a unicode character. For
\code{tk2unicode_bind()} it must be a \code{tk2text} or a \code{tk2entry} widget.}
}
\value{
The selection made in the dialog box if \code{OK} is clicked, \code{""} otherwise for
\code{\link[=tk2chooseFont]{tk2chooseFont()}}.

The \code{\link[=tk2unicode_select]{tk2unicode_select()}} dialog pastes the selected unicode character in the
designed widget, but returns nothing. The \code{\link[=tk2unicode_config]{tk2unicode_config()}} changes the
configuration for the unicode composer, but returns nothing. If you decide to
do so, it saves the config on a file. This is done app-by-app, and the
default app name is \code{"R"}. You can change it by setting a different
value in the option \code{"tk2app"}, i.e., \code{options(tk2app = "myApp")}.
The \code{tk2unicode_bind()} is also invoked for its side-effect to install
required bindings to enable the unicode composer engine for the given widget
and it returns nothing.
}
\description{
Tk dialog boxes to select a font, unicode characters or a list of ordered
items.
}
\examples{
\dontrun{
library(tcltk2)
# These cannot be run by examples() but should be OK when pasted
# into an interactive R session with the tcltk package loaded

# Font selection
tk2chooseFont()
tk2chooseFont(font = "{courier} 9", title = "Choose a fixed font",
  fonttype = "fixed", style = 4, sizetype = "all")
tk2chooseFont(font = "Verdana 12 bold italic underline overstrike",
  fonttype = "prop", style = 2, sizetype = "point")

# Easy unicode character entry
tt <- tktoplevel()
txt <- tk2text(tt, width = 60, height = 20)
tkpack(txt)
e <- tk2entry(tt, width = 50)
tkpack(e)
# Get an unicode character for the text widget
tk2unicode_select(txt)
# and for the entry widget
tk2unicode_select(e)

# Bind the composer to both the text and the entry widgets
# and display the configuration box
# Once done, try the compose key + m + u, or compose + " + a
# or any othert sequence in both widgets
# or hit the compose key twice
tk2unicode_bind(txt)
tk2unicode_bind(e)
tk2unicode_config(tt)
}
}
\seealso{
\code{\link[=tk2text]{tk2text()}}, \code{\link[=tk2listbox]{tk2listbox()}}, \code{\link[=tk2list.insert]{tk2list.insert()}}
}
\author{
Philippe Grosjean
}
\keyword{utilities}
