% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lockfile-validate.R
\name{lockfile_validate}
\alias{lockfile_validate}
\title{Validate an renv lockfile against a schema}
\usage{
lockfile_validate(
  project = NULL,
  lockfile = NULL,
  schema = NULL,
  greedy = FALSE,
  error = FALSE,
  verbose = FALSE,
  strict = FALSE
)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{lockfile}{Contents of the lockfile, or a filename containing one.
If not provided, it defaults to the project's lockfile.}

\item{schema}{Contents of a renv schema, or a filename containing a schema.
If not provided, renv's default schema is used.}

\item{greedy}{Boolean. Continue after first error?}

\item{error}{Boolean. Throw an error on parse failure?}

\item{verbose}{Boolean. If \code{TRUE}, then an attribute \code{errors} will list
validation failures as a \code{data.frame}.}

\item{strict}{Boolean. Set whether the schema should be parsed strictly or
not. If in strict mode schemas will error to "prevent any unexpected
behaviours or silently ignored mistakes in user schema". For example it
will error if encounters unknown formats or unknown keywords. See
https://ajv.js.org/strict-mode.html for details.}
}
\value{
Boolean. \code{TRUE} if validation passes. \code{FALSE} if validation fails.
}
\description{
\code{renv::lockfile_validate()} can be used to validate your \code{renv.lock}
against a default or custom schema. It can be used to automate checks,
check for obvious errors, and ensure that any custom fields you add fit
your specific needs.
}
\details{
See the \href{https://json-schema.org/}{JSON Schema docs} for more information
on JSON schemas, their use in validation, and how to write your own schema.

\code{renv::lockfile_validate()} wraps ROpenSci's
\href{https://docs.ropensci.org/jsonvalidate/}{\code{jsonvalidate}} package, passing
many of its parameters to that package's \code{json_validate()} function. Use
\code{?jsonvalidate::json_validate} for more information.
}
\examples{
\dontrun{

# validate the project's lockfile
renv::lockfile_validate()

# validate the project's lockfile using a non-default schema
renv::lockfile_validate(schema = "/path/to/your/custom/schema.json")

# validate a lockfile using its path
renv::lockfile_validate(lockfile = "/path/to/your/renv.lock")
}

}
\keyword{internal}
