% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lineage.R
\name{graphToPhylo}
\alias{graphToPhylo}
\title{Convert a tree in igraph \code{graph} format to ape \code{phylo} format.}
\usage{
graphToPhylo(graph)
}
\arguments{
\item{graph}{An igraph \code{graph} object.}
}
\value{
A \code{phylo} object representing the input tree. Tip and internal node names are 
          stored in the \code{tip.label} and \code{node.label} vectors, respectively.
}
\description{
\code{graphToPhylo} a tree in igraph \code{graph} format to ape \code{phylo} 
format.
}
\details{
Convert from igraph \code{graph} object to ape \code{phylo} object. If \code{graph} object
was previously rooted with the germline as the direct ancestor, this will re-attach the 
germline as a descendant node with a zero branch length to a new universal common ancestor (UCA) 
node and store the germline node ID in the \code{germid} attribute and UCA node number in 
the \code{uca} attribute. Otherwise these attributes will not be specified in the \code{phylo} object. 
Using \code{phyloToGraph(phylo, germline=phylo$germid)} creates a \code{graph} object with the germline 
back as the direct ancestor. Tip and internal node names are 
stored in the \code{tip.label} and \code{node.label} vectors, respectively.
}
\examples{
\dontrun{
   library(igraph)
   library(ape)

   #convert to phylo
   phylo = graphToPhylo(graph)
   
   #plot tree using ape
   plot(phylo,show.node.label=TRUE)
   
   #store as newick tree
   write.tree(phylo,file="tree.newick")
   
   #read in tree from newick file
   phylo_r = read.tree("tree.newick")
   
   #convert to igraph
   graph_r = phyloToGraph(phylo_r,germline="Germline")
   
   #plot graph - same as before, possibly rotated
   plot(graph_r,layout=layout_as_tree)
}

}
\references{
\enumerate{
  \item  Hoehn KB, Lunter G, Pybus OG - A Phylogenetic Codon Substitution Model for Antibody 
             Lineages. Genetics 2017 206(1):417-427
             https://doi.org/10.1534/genetics.116.196303 
 \item  Hoehn KB, Vander Heiden JA, Zhou JQ, Lunter G, Pybus OG, Kleinstein SHK - 
             Repertoire-wide phylogenetic models of B cell molecular evolution reveal 
             evolutionary signatures of aging and vaccination. bioRxiv 2019  
             https://doi.org/10.1101/558825 
}
}
