# coding: utf-8

"""
    CLOUD API

     IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class VolumeProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'name': 'str',

        'type': 'str',

        'size': 'float',

        'availability_zone': 'str',

        'image': 'str',

        'image_password': 'str',

        'image_alias': 'str',

        'ssh_keys': 'list[str]',

        'bus': 'str',

        'licence_type': 'str',

        'application_type': 'str',

        'cpu_hot_plug': 'bool',

        'ram_hot_plug': 'bool',

        'nic_hot_plug': 'bool',

        'nic_hot_unplug': 'bool',

        'disc_virtio_hot_plug': 'bool',

        'disc_virtio_hot_unplug': 'bool',

        'expose_serial': 'bool',

        'require_legacy_bios': 'bool',

        'device_number': 'int',

        'pci_slot': 'int',

        'backupunit_id': 'str',

        'user_data': 'str',

        'boot_server': 'str',

        'boot_order': 'str',
    }

    attribute_map = {

        'name': 'name',

        'type': 'type',

        'size': 'size',

        'availability_zone': 'availabilityZone',

        'image': 'image',

        'image_password': 'imagePassword',

        'image_alias': 'imageAlias',

        'ssh_keys': 'sshKeys',

        'bus': 'bus',

        'licence_type': 'licenceType',

        'application_type': 'applicationType',

        'cpu_hot_plug': 'cpuHotPlug',

        'ram_hot_plug': 'ramHotPlug',

        'nic_hot_plug': 'nicHotPlug',

        'nic_hot_unplug': 'nicHotUnplug',

        'disc_virtio_hot_plug': 'discVirtioHotPlug',

        'disc_virtio_hot_unplug': 'discVirtioHotUnplug',

        'expose_serial': 'exposeSerial',

        'require_legacy_bios': 'requireLegacyBios',

        'device_number': 'deviceNumber',

        'pci_slot': 'pciSlot',

        'backupunit_id': 'backupunitId',

        'user_data': 'userData',

        'boot_server': 'bootServer',

        'boot_order': 'bootOrder',
    }

    def __init__(self, name=None, type=None, size=None, availability_zone=None, image=None, image_password=None, image_alias=None, ssh_keys=None, bus=None, licence_type=None, application_type=None, cpu_hot_plug=None, ram_hot_plug=None, nic_hot_plug=None, nic_hot_unplug=None, disc_virtio_hot_plug=None, disc_virtio_hot_unplug=None, expose_serial=False, require_legacy_bios=True, device_number=None, pci_slot=None, backupunit_id=None, user_data=None, boot_server=None, boot_order='AUTO', local_vars_configuration=None):  # noqa: E501
        """VolumeProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._type = None
        self._size = None
        self._availability_zone = None
        self._image = None
        self._image_password = None
        self._image_alias = None
        self._ssh_keys = None
        self._bus = None
        self._licence_type = None
        self._application_type = None
        self._cpu_hot_plug = None
        self._ram_hot_plug = None
        self._nic_hot_plug = None
        self._nic_hot_unplug = None
        self._disc_virtio_hot_plug = None
        self._disc_virtio_hot_unplug = None
        self._expose_serial = None
        self._require_legacy_bios = None
        self._device_number = None
        self._pci_slot = None
        self._backupunit_id = None
        self._user_data = None
        self._boot_server = None
        self._boot_order = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if type is not None:
            self.type = type
        if size is not None:
            self.size = size
        if availability_zone is not None:
            self.availability_zone = availability_zone
        if image is not None:
            self.image = image
        if image_password is not None:
            self.image_password = image_password
        if image_alias is not None:
            self.image_alias = image_alias
        if ssh_keys is not None:
            self.ssh_keys = ssh_keys
        if bus is not None:
            self.bus = bus
        if licence_type is not None:
            self.licence_type = licence_type
        if application_type is not None:
            self.application_type = application_type
        if cpu_hot_plug is not None:
            self.cpu_hot_plug = cpu_hot_plug
        if ram_hot_plug is not None:
            self.ram_hot_plug = ram_hot_plug
        if nic_hot_plug is not None:
            self.nic_hot_plug = nic_hot_plug
        if nic_hot_unplug is not None:
            self.nic_hot_unplug = nic_hot_unplug
        if disc_virtio_hot_plug is not None:
            self.disc_virtio_hot_plug = disc_virtio_hot_plug
        if disc_virtio_hot_unplug is not None:
            self.disc_virtio_hot_unplug = disc_virtio_hot_unplug
        if expose_serial is not None:
            self.expose_serial = expose_serial
        if require_legacy_bios is not None:
            self.require_legacy_bios = require_legacy_bios
        if device_number is not None:
            self.device_number = device_number
        if pci_slot is not None:
            self.pci_slot = pci_slot
        if backupunit_id is not None:
            self.backupunit_id = backupunit_id
        if user_data is not None:
            self.user_data = user_data
        if boot_server is not None:
            self.boot_server = boot_server
        self.boot_order = boot_order


    @property
    def name(self):
        """Gets the name of this VolumeProperties.  # noqa: E501

        The name of the  resource.  # noqa: E501

        :return: The name of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this VolumeProperties.

        The name of the  resource.  # noqa: E501

        :param name: The name of this VolumeProperties.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def type(self):
        """Gets the type of this VolumeProperties.  # noqa: E501

        Hardware type of the volume. DAS (Direct Attached Storage) could be used only in a composite call with a Cube server.  # noqa: E501

        :return: The type of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this VolumeProperties.

        Hardware type of the volume. DAS (Direct Attached Storage) could be used only in a composite call with a Cube server.  # noqa: E501

        :param type: The type of this VolumeProperties.  # noqa: E501
        :type type: str
        """
        allowed_values = ["HDD", "SSD", "SSD Standard", "SSD Premium", "DAS", "ISO"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def size(self):
        """Gets the size of this VolumeProperties.  # noqa: E501

        The size of the volume in GB.  # noqa: E501

        :return: The size of this VolumeProperties.  # noqa: E501
        :rtype: float
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this VolumeProperties.

        The size of the volume in GB.  # noqa: E501

        :param size: The size of this VolumeProperties.  # noqa: E501
        :type size: float
        """

        self._size = size

    @property
    def availability_zone(self):
        """Gets the availability_zone of this VolumeProperties.  # noqa: E501

        The availability zone in which the volume should be provisioned. The storage volume will be provisioned on as few physical storage devices as possible, but this cannot be guaranteed upfront. This is uavailable for DAS (Direct Attached Storage), and subject to availability for SSD.  # noqa: E501

        :return: The availability_zone of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._availability_zone

    @availability_zone.setter
    def availability_zone(self, availability_zone):
        """Sets the availability_zone of this VolumeProperties.

        The availability zone in which the volume should be provisioned. The storage volume will be provisioned on as few physical storage devices as possible, but this cannot be guaranteed upfront. This is uavailable for DAS (Direct Attached Storage), and subject to availability for SSD.  # noqa: E501

        :param availability_zone: The availability_zone of this VolumeProperties.  # noqa: E501
        :type availability_zone: str
        """
        allowed_values = ["AUTO", "ZONE_1", "ZONE_2", "ZONE_3"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and availability_zone not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `availability_zone` ({0}), must be one of {1}"  # noqa: E501
                .format(availability_zone, allowed_values)
            )

        self._availability_zone = availability_zone

    @property
    def image(self):
        """Gets the image of this VolumeProperties.  # noqa: E501

        Image or snapshot ID to be used as template for this volume. MSSQL Enterprise Images can be used only if the feature toggle for MSSQL Enterprise is enabled on the contract.  # noqa: E501

        :return: The image of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this VolumeProperties.

        Image or snapshot ID to be used as template for this volume. MSSQL Enterprise Images can be used only if the feature toggle for MSSQL Enterprise is enabled on the contract.  # noqa: E501

        :param image: The image of this VolumeProperties.  # noqa: E501
        :type image: str
        """

        self._image = image

    @property
    def image_password(self):
        """Gets the image_password of this VolumeProperties.  # noqa: E501

        Initial password to be set for installed OS. Works with public images only. Not modifiable, forbidden in update requests. Password rules allows all characters from a-z, A-Z, 0-9.  # noqa: E501

        :return: The image_password of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._image_password

    @image_password.setter
    def image_password(self, image_password):
        """Sets the image_password of this VolumeProperties.

        Initial password to be set for installed OS. Works with public images only. Not modifiable, forbidden in update requests. Password rules allows all characters from a-z, A-Z, 0-9.  # noqa: E501

        :param image_password: The image_password of this VolumeProperties.  # noqa: E501
        :type image_password: str
        """

        self._image_password = image_password

    @property
    def image_alias(self):
        """Gets the image_alias of this VolumeProperties.  # noqa: E501

        Image alias of an image to be used as template for this volume. MSSQL Enterprise Images can be used only if the feature toggle for MSSQL Enterprise is enabled on the contract.  # noqa: E501

        :return: The image_alias of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._image_alias

    @image_alias.setter
    def image_alias(self, image_alias):
        """Sets the image_alias of this VolumeProperties.

        Image alias of an image to be used as template for this volume. MSSQL Enterprise Images can be used only if the feature toggle for MSSQL Enterprise is enabled on the contract.  # noqa: E501

        :param image_alias: The image_alias of this VolumeProperties.  # noqa: E501
        :type image_alias: str
        """

        self._image_alias = image_alias

    @property
    def ssh_keys(self):
        """Gets the ssh_keys of this VolumeProperties.  # noqa: E501

        Public SSH keys are set on the image as authorized keys for appropriate SSH login to the instance using the corresponding private key. This field may only be set in creation requests. When reading, it always returns null. SSH keys are only supported if a public Linux image is used for the volume creation.  # noqa: E501

        :return: The ssh_keys of this VolumeProperties.  # noqa: E501
        :rtype: list[str]
        """
        return self._ssh_keys

    @ssh_keys.setter
    def ssh_keys(self, ssh_keys):
        """Sets the ssh_keys of this VolumeProperties.

        Public SSH keys are set on the image as authorized keys for appropriate SSH login to the instance using the corresponding private key. This field may only be set in creation requests. When reading, it always returns null. SSH keys are only supported if a public Linux image is used for the volume creation.  # noqa: E501

        :param ssh_keys: The ssh_keys of this VolumeProperties.  # noqa: E501
        :type ssh_keys: list[str]
        """

        self._ssh_keys = ssh_keys

    @property
    def bus(self):
        """Gets the bus of this VolumeProperties.  # noqa: E501

        The bus type for this volume; default is VIRTIO.  # noqa: E501

        :return: The bus of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._bus

    @bus.setter
    def bus(self, bus):
        """Sets the bus of this VolumeProperties.

        The bus type for this volume; default is VIRTIO.  # noqa: E501

        :param bus: The bus of this VolumeProperties.  # noqa: E501
        :type bus: str
        """
        allowed_values = ["VIRTIO", "IDE", "UNKNOWN"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and bus not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `bus` ({0}), must be one of {1}"  # noqa: E501
                .format(bus, allowed_values)
            )

        self._bus = bus

    @property
    def licence_type(self):
        """Gets the licence_type of this VolumeProperties.  # noqa: E501

        OS type for this volume.  # noqa: E501

        :return: The licence_type of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._licence_type

    @licence_type.setter
    def licence_type(self, licence_type):
        """Sets the licence_type of this VolumeProperties.

        OS type for this volume.  # noqa: E501

        :param licence_type: The licence_type of this VolumeProperties.  # noqa: E501
        :type licence_type: str
        """
        allowed_values = ["UNKNOWN", "WINDOWS", "WINDOWS2016", "WINDOWS2019", "WINDOWS2022", "WINDOWS2025", "RHEL", "LINUX", "OTHER"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and licence_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `licence_type` ({0}), must be one of {1}"  # noqa: E501
                .format(licence_type, allowed_values)
            )

        self._licence_type = licence_type

    @property
    def application_type(self):
        """Gets the application_type of this VolumeProperties.  # noqa: E501

        The type of application that is hosted on this resource.  Only public images can have an Application type different than UNKNOWN.  # noqa: E501

        :return: The application_type of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._application_type

    @application_type.setter
    def application_type(self, application_type):
        """Sets the application_type of this VolumeProperties.

        The type of application that is hosted on this resource.  Only public images can have an Application type different than UNKNOWN.  # noqa: E501

        :param application_type: The application_type of this VolumeProperties.  # noqa: E501
        :type application_type: str
        """

        self._application_type = application_type

    @property
    def cpu_hot_plug(self):
        """Gets the cpu_hot_plug of this VolumeProperties.  # noqa: E501

        Hot-plug capable CPU (no reboot required).  # noqa: E501

        :return: The cpu_hot_plug of this VolumeProperties.  # noqa: E501
        :rtype: bool
        """
        return self._cpu_hot_plug

    @cpu_hot_plug.setter
    def cpu_hot_plug(self, cpu_hot_plug):
        """Sets the cpu_hot_plug of this VolumeProperties.

        Hot-plug capable CPU (no reboot required).  # noqa: E501

        :param cpu_hot_plug: The cpu_hot_plug of this VolumeProperties.  # noqa: E501
        :type cpu_hot_plug: bool
        """

        self._cpu_hot_plug = cpu_hot_plug

    @property
    def ram_hot_plug(self):
        """Gets the ram_hot_plug of this VolumeProperties.  # noqa: E501

        Hot-plug capable RAM (no reboot required).  # noqa: E501

        :return: The ram_hot_plug of this VolumeProperties.  # noqa: E501
        :rtype: bool
        """
        return self._ram_hot_plug

    @ram_hot_plug.setter
    def ram_hot_plug(self, ram_hot_plug):
        """Sets the ram_hot_plug of this VolumeProperties.

        Hot-plug capable RAM (no reboot required).  # noqa: E501

        :param ram_hot_plug: The ram_hot_plug of this VolumeProperties.  # noqa: E501
        :type ram_hot_plug: bool
        """

        self._ram_hot_plug = ram_hot_plug

    @property
    def nic_hot_plug(self):
        """Gets the nic_hot_plug of this VolumeProperties.  # noqa: E501

        Hot-plug capable NIC (no reboot required).  # noqa: E501

        :return: The nic_hot_plug of this VolumeProperties.  # noqa: E501
        :rtype: bool
        """
        return self._nic_hot_plug

    @nic_hot_plug.setter
    def nic_hot_plug(self, nic_hot_plug):
        """Sets the nic_hot_plug of this VolumeProperties.

        Hot-plug capable NIC (no reboot required).  # noqa: E501

        :param nic_hot_plug: The nic_hot_plug of this VolumeProperties.  # noqa: E501
        :type nic_hot_plug: bool
        """

        self._nic_hot_plug = nic_hot_plug

    @property
    def nic_hot_unplug(self):
        """Gets the nic_hot_unplug of this VolumeProperties.  # noqa: E501

        Hot-unplug capable NIC (no reboot required).  # noqa: E501

        :return: The nic_hot_unplug of this VolumeProperties.  # noqa: E501
        :rtype: bool
        """
        return self._nic_hot_unplug

    @nic_hot_unplug.setter
    def nic_hot_unplug(self, nic_hot_unplug):
        """Sets the nic_hot_unplug of this VolumeProperties.

        Hot-unplug capable NIC (no reboot required).  # noqa: E501

        :param nic_hot_unplug: The nic_hot_unplug of this VolumeProperties.  # noqa: E501
        :type nic_hot_unplug: bool
        """

        self._nic_hot_unplug = nic_hot_unplug

    @property
    def disc_virtio_hot_plug(self):
        """Gets the disc_virtio_hot_plug of this VolumeProperties.  # noqa: E501

        Hot-plug capable Virt-IO drive (no reboot required).  # noqa: E501

        :return: The disc_virtio_hot_plug of this VolumeProperties.  # noqa: E501
        :rtype: bool
        """
        return self._disc_virtio_hot_plug

    @disc_virtio_hot_plug.setter
    def disc_virtio_hot_plug(self, disc_virtio_hot_plug):
        """Sets the disc_virtio_hot_plug of this VolumeProperties.

        Hot-plug capable Virt-IO drive (no reboot required).  # noqa: E501

        :param disc_virtio_hot_plug: The disc_virtio_hot_plug of this VolumeProperties.  # noqa: E501
        :type disc_virtio_hot_plug: bool
        """

        self._disc_virtio_hot_plug = disc_virtio_hot_plug

    @property
    def disc_virtio_hot_unplug(self):
        """Gets the disc_virtio_hot_unplug of this VolumeProperties.  # noqa: E501

        Hot-unplug capable Virt-IO drive (no reboot required). Not supported with Windows VMs.  # noqa: E501

        :return: The disc_virtio_hot_unplug of this VolumeProperties.  # noqa: E501
        :rtype: bool
        """
        return self._disc_virtio_hot_unplug

    @disc_virtio_hot_unplug.setter
    def disc_virtio_hot_unplug(self, disc_virtio_hot_unplug):
        """Sets the disc_virtio_hot_unplug of this VolumeProperties.

        Hot-unplug capable Virt-IO drive (no reboot required). Not supported with Windows VMs.  # noqa: E501

        :param disc_virtio_hot_unplug: The disc_virtio_hot_unplug of this VolumeProperties.  # noqa: E501
        :type disc_virtio_hot_unplug: bool
        """

        self._disc_virtio_hot_unplug = disc_virtio_hot_unplug

    @property
    def expose_serial(self):
        """Gets the expose_serial of this VolumeProperties.  # noqa: E501

        If set to `true` will expose the serial id of the disk attached to the server. If set to `false` will not expose the serial id. Some operating systems or software solutions require the serial id to be exposed to work properly. Exposing the serial  can influence licensed software (e.g. Windows) behavior  # noqa: E501

        :return: The expose_serial of this VolumeProperties.  # noqa: E501
        :rtype: bool
        """
        return self._expose_serial

    @expose_serial.setter
    def expose_serial(self, expose_serial):
        """Sets the expose_serial of this VolumeProperties.

        If set to `true` will expose the serial id of the disk attached to the server. If set to `false` will not expose the serial id. Some operating systems or software solutions require the serial id to be exposed to work properly. Exposing the serial  can influence licensed software (e.g. Windows) behavior  # noqa: E501

        :param expose_serial: The expose_serial of this VolumeProperties.  # noqa: E501
        :type expose_serial: bool
        """

        self._expose_serial = expose_serial

    @property
    def require_legacy_bios(self):
        """Gets the require_legacy_bios of this VolumeProperties.  # noqa: E501

        Indicates if the image requires the legacy BIOS for compatibility or specific needs.  # noqa: E501

        :return: The require_legacy_bios of this VolumeProperties.  # noqa: E501
        :rtype: bool
        """
        return self._require_legacy_bios

    @require_legacy_bios.setter
    def require_legacy_bios(self, require_legacy_bios):
        """Sets the require_legacy_bios of this VolumeProperties.

        Indicates if the image requires the legacy BIOS for compatibility or specific needs.  # noqa: E501

        :param require_legacy_bios: The require_legacy_bios of this VolumeProperties.  # noqa: E501
        :type require_legacy_bios: bool
        """

        self._require_legacy_bios = require_legacy_bios

    @property
    def device_number(self):
        """Gets the device_number of this VolumeProperties.  # noqa: E501

        The Logical Unit Number of the storage volume. Null for volumes, not mounted to a VM.  # noqa: E501

        :return: The device_number of this VolumeProperties.  # noqa: E501
        :rtype: int
        """
        return self._device_number

    @device_number.setter
    def device_number(self, device_number):
        """Sets the device_number of this VolumeProperties.

        The Logical Unit Number of the storage volume. Null for volumes, not mounted to a VM.  # noqa: E501

        :param device_number: The device_number of this VolumeProperties.  # noqa: E501
        :type device_number: int
        """

        self._device_number = device_number

    @property
    def pci_slot(self):
        """Gets the pci_slot of this VolumeProperties.  # noqa: E501

        The PCI slot number of the storage volume. Null for volumes, not mounted to a VM.  # noqa: E501

        :return: The pci_slot of this VolumeProperties.  # noqa: E501
        :rtype: int
        """
        return self._pci_slot

    @pci_slot.setter
    def pci_slot(self, pci_slot):
        """Sets the pci_slot of this VolumeProperties.

        The PCI slot number of the storage volume. Null for volumes, not mounted to a VM.  # noqa: E501

        :param pci_slot: The pci_slot of this VolumeProperties.  # noqa: E501
        :type pci_slot: int
        """

        self._pci_slot = pci_slot

    @property
    def backupunit_id(self):
        """Gets the backupunit_id of this VolumeProperties.  # noqa: E501

        The ID of the backup unit that the user has access to. The property is immutable and is only allowed to be set on creation of a new a volume. It is mandatory to provide either 'public image' or 'imageAlias' in conjunction with this property.  # noqa: E501

        :return: The backupunit_id of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._backupunit_id

    @backupunit_id.setter
    def backupunit_id(self, backupunit_id):
        """Sets the backupunit_id of this VolumeProperties.

        The ID of the backup unit that the user has access to. The property is immutable and is only allowed to be set on creation of a new a volume. It is mandatory to provide either 'public image' or 'imageAlias' in conjunction with this property.  # noqa: E501

        :param backupunit_id: The backupunit_id of this VolumeProperties.  # noqa: E501
        :type backupunit_id: str
        """

        self._backupunit_id = backupunit_id

    @property
    def user_data(self):
        """Gets the user_data of this VolumeProperties.  # noqa: E501

        The cloud-init configuration for the volume as base64 encoded string. The property is immutable and is only allowed to be set on creation of a new a volume. It is mandatory to provide either 'public image' or 'imageAlias' that has cloud-init compatibility in conjunction with this property.  # noqa: E501

        :return: The user_data of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._user_data

    @user_data.setter
    def user_data(self, user_data):
        """Sets the user_data of this VolumeProperties.

        The cloud-init configuration for the volume as base64 encoded string. The property is immutable and is only allowed to be set on creation of a new a volume. It is mandatory to provide either 'public image' or 'imageAlias' that has cloud-init compatibility in conjunction with this property.  # noqa: E501

        :param user_data: The user_data of this VolumeProperties.  # noqa: E501
        :type user_data: str
        """

        self._user_data = user_data

    @property
    def boot_server(self):
        """Gets the boot_server of this VolumeProperties.  # noqa: E501

        The UUID of the attached server.  # noqa: E501

        :return: The boot_server of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._boot_server

    @boot_server.setter
    def boot_server(self, boot_server):
        """Sets the boot_server of this VolumeProperties.

        The UUID of the attached server.  # noqa: E501

        :param boot_server: The boot_server of this VolumeProperties.  # noqa: E501
        :type boot_server: str
        """

        self._boot_server = boot_server

    @property
    def boot_order(self):
        """Gets the boot_order of this VolumeProperties.  # noqa: E501

        Determines whether the volume will be used as a boot volume. Set to `NONE`, the volume will not be used as boot volume. Set to `PRIMARY`, the volume will be used as boot volume and all other volumes must be set to `NONE`. Set to `AUTO` or `null` requires all volumes to be set to `AUTO` or `null`; this will use the legacy behavior, which is to use the volume as a boot volume only if there are no other volumes or cdrom devices.  # noqa: E501

        :return: The boot_order of this VolumeProperties.  # noqa: E501
        :rtype: str
        """
        return self._boot_order

    @boot_order.setter
    def boot_order(self, boot_order):
        """Sets the boot_order of this VolumeProperties.

        Determines whether the volume will be used as a boot volume. Set to `NONE`, the volume will not be used as boot volume. Set to `PRIMARY`, the volume will be used as boot volume and all other volumes must be set to `NONE`. Set to `AUTO` or `null` requires all volumes to be set to `AUTO` or `null`; this will use the legacy behavior, which is to use the volume as a boot volume only if there are no other volumes or cdrom devices.  # noqa: E501

        :param boot_order: The boot_order of this VolumeProperties.  # noqa: E501
        :type boot_order: str
        """
        allowed_values = [None,"AUTO", "NONE", "PRIMARY"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and boot_order not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `boot_order` ({0}), must be one of {1}"  # noqa: E501
                .format(boot_order, allowed_values)
            )

        self._boot_order = boot_order
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VolumeProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VolumeProperties):
            return True

        return self.to_dict() != other.to_dict()
