# Quotes
Quotes database example, which demonstrates the Elasticsearch integration with
Pydantic models. This example features a React frontend and a FastAPI back end.

![Quotes app screenshot](screenshot.png)

## What is this?

This directory contains a small application that demonstrates how easy it is
to set up a full-text and vector database using [Elasticsearch](https://www.elastic.co/elasticsearch),
while defining the data model with [Pydantic](https://docs.pydantic.dev/latest/).

The application includes a FastAPI back end and a React front end. It ingests a
dataset of famous quotes into in an Elasticsearch index, and for each quote it
generates an embedding using the
[all-MiniLM-L6-v2](https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2)
Sentence Transformers model.

The dataset has about 850 famous quotes, each with their author and tags. The
data is a subset of a
[Kaggle dataset](https://www.kaggle.com/datasets/akmittal/quotes-dataset) that
appears to have been generated from quotes that were scraped from the Goodreads
[popular quotes](https://www.goodreads.com/quotes) page.

## Requirements

Please make sure you have the following installed:

- Python 3.10 or newer
- Node.js 18 or newer

## How To Run

Follow these steps to install this demo on your computer:

### Clone this repository

Run the following command to install a copy of this project on your computer:

```bash
git clone https://github.com/elastic/elasticsearch-py
cd examples/quotes
```

### Install the Node and Python dependencies

Run the following command to set up the JavaScript and Python environment and
install all the dependencies:

```bash
npm install
```

### Start a development Elasticsearch container

You can use [start-local](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/local-development-installation-quickstart)
to start a small Elasticsearch instance.

Use this command to launch the instance (Docker and Docker Compose are required):

```bash
curl -fsSL https://elastic.co/start-local | sh
```

Once your Elasticsearch instead is deployed, create an environment variable called
`ELASTICSEARCH_URL`, making sure it includes the password generated by start-local.
Example:

```bash
export ELASTICSEARCH_URL=http://elastic:your-password-here@localhost:9200
```

### Create the quotes database

Run this command in your terminal:

```bash
npm run ingest
```

Note that the `ELASTICSEARCH_URL` variable must be defined in the terminal
session in which you run this command.

This task should take a minute or less. The GPU, if available, is used optimize
the generation of the embeddings.

### Start the back end

Run this command in your terminal:

```bash
npm run backend
```

Note that the `ELASTICSEARCH_URL` variable must be defined in the terminal
session in which you run this command.

### Start the front end

Open a second terminal window and run this command:

```bash
npm run dev
```

You can now navigate to `http://localhost:5173` on your web browser to access
the application.
