ITK Release 5.0 Beta 3
======================

We are happy to announce the Insight Toolkit (ITK) version 5 Beta 3 release! :tada:  This release celebrates the community's migration to GitHub. :octocat: As a true open source project, community participation is a high priority. :handshake: Our migration to GitHub facilitates collaboration with the broader scientific open source community. :microscope:

![itkongithub](https://user-images.githubusercontent.com/25432/50700001-6f5a6c80-1017-11e9-94f9-5ddb4b67e4c4.png)

This release also includes major improvements in the areas of performance and third party libraries. A new, experimental `ImageRange` class enables iteration over an image's pixels in a modern, performant way. Fundamental ITK data structures were improved to enabled compiler optimizations for Plain Old Data objects. [VXL](https://vxl.github.io/) was modernized to C++11, and [Eigen](https://eigen.tuxfamily.org/index.php?title=Main_Page) is now available in the toolkit; ITK's gradual transition from VXL to Eigen for linear algebra has begun.

In addition, four new remote modules are available, FFT's can be computed on the GPU via [cuFFTW](https://docs.nvidia.com/cuda/cufft/index.html), and ITK Python's `itk.imread` now supports image series. More information can be found in the feature summary below.

For an overview of ITK 5's transition to modern C++, performance-related changes, and the new, Pythonic API, see the [ITK 5 Alpha 1: Modern C++](https://discourse.itk.org/t/itk-5-0-alpha-1-modern-c/843/7), [ITK 5 Alpha 2: Performance](https://discourse.itk.org/t/itk-5-0-alpha-2-performance/959), and [ITK 5 Beta 1: Pythonic Interface](https://discourse.itk.org/t/itk-5-0-beta-1-pythonic-interface/1271) release announcements.

GitHub Migration
------------------------

GitHub now hosts the official  *ITK*, *ITKExamples*, and *ITKSoftwareGuide* Git repositories:

- [`https://github.com/InsightSoftwareConsortium/ITK.git`](https://github.com/InsightSoftwareConsortium/ITK)
- [`https://github.com/InsightSoftwareConsortium/ITKExamples.git`](https://github.com/InsightSoftwareConsortium/ITKExamples)
- [`https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide.git`](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide)

The [*InsightSoftwareConsortium* GitHub Organization](https://github.com/InsightSoftwareConsortium) is currently home to 88 other ITK-related repositories. Many of these repositories are externally developed [ITK modules](https://itk.org/ITKSoftwareGuide/html/Book1/ITKSoftwareGuide-Book1ch9.html#x50-1430009). If you would like create a new repository or transfer a repository to the InsightSoftwareConsortium GitHub organization, let us know on [ITK's Discourse](https://discourse.itk.org/) discussion forum.

Documentation on *how to contribute* has been updated and improved.  Contribution documentation is available in the [ITK Software Guide](https://itk.org/ITKSoftwareGuide/html/) and as Markdown files in the source code repository, browsable in [GitHub's web interface](https://github.com/InsightSoftwareConsortium/ITK/tree/master/Documentation). Our [*CONTRIBUTING.md*](https://github.com/InsightSoftwareConsortium/ITK/blob/master/CONTRIBUTING.md) file is a starting point for contributors. We also have a [Git cheatsheet](https://raw.githubusercontent.com/InsightSoftwareConsortium/ITK/master/Documentation/GitCheatSheet.pdf) for quick reference.

Our [Code of Conduct](https://github.com/InsightSoftwareConsortium/ITK/blob/master/CODE_OF_CONDUCT.md) describes our [motivation](https://github.com/InsightSoftwareConsortium/ITK/blob/master/Documentation/CodeOfConduct/Motivation.md) to build impactful, open source image analysis software through a welcoming and productive community. The Code of Conduct also describes our values: to be open, welcoming, inclusive, civil and considerate, respectful, collaborative, careful in the words that we choose, responsible, and inquisitive. We expect community members to lead by example, but we also define a set of unacceptable behaviors and mechanisms to enforce conduct violations.

To guide submission of pull requests and issues, we created templates used when [issues](https://github.com/InsightSoftwareConsortium/ITK/blob/master/.github/ISSUE_TEMPLATE.md) and [pull requests](https://github.com/InsightSoftwareConsortium/ITK/blob/master/.github/PULL_REQUEST_TEMPLATE.md) are opened. Release notes from previous releases were migrated from the Wiki; release notes can be browsed in [repository Markdown files](https://github.com/InsightSoftwareConsortium/ITK/tree/master/Documentation/ReleaseNotes).

Plans for upcoming releases can now be found in the [project GitHub Milestones](https://github.com/InsightSoftwareConsortium/ITK/milestones). Release artifacts will now be published on [ITK's GitHub Releases](https://github.com/InsightSoftwareConsortium/ITK/releases) as opposed to Sourceforge. [Release artifact archives](https://data.kitware.com/#collection/57b5c9e58d777f126827f5a1/folder/5b1ec0378d777f2e622561e9) are now also available in the [ITK data.kitware.com Girder Collection](https://data.kitware.com/#collection/57b5c9e58d777f126827f5a1).

The `./Utilities/SetupForDevelopment.sh` script now guides repository configuration for GitHub contributions. Git client-side hooks help submit a well-formatted commit message. Git aliases, `review-push` and `pr`, are provided to submit pull requests for review and download submitted pull requests for local testing.

A new cross platform script, [`ITK/Utilities/UploadBinaryData.sh`](https://github.com/InsightSoftwareConsortium/ITK/blob/master/Utilities/UploadBinaryData.sh), is available to upload binary testing data. This script, invoked directly or through the `data-upload` alias, performs an authenticated upload to [data.kitware.com](https://data.kitware.com) and generates an [ExternalData content link](https://github.com/InsightSoftwareConsortium/ITK/blob/master/Documentation/Data.md) to avoid inflation of the source code repository's size. This script can be used to [upload testing data for ITK](https://github.com/InsightSoftwareConsortium/ITK/blob/master/Documentation/UploadBinaryData.md) or [an externally developed module](https://github.com/InsightSoftwareConsortium/ITKModuleTemplate).

A static archive of our previous code review system, the [*https://review.source.kitware.com/*](https://review.source.kitware.com) Gerrit Code Review instance, was created to preserve the code review discussions for nearly 24,000 changes on ITK and other Kitware supported projects.

Continuous integration testing ensures the continued quality and productive development of the toolkit. CircleCI and Azure Pipelines CI testing run over 2,800 regression tests on Linux, macOS, and Windows for both C++ and Python builds. Pull requests content is checked by [ghostflow-director](https://gitlab.kitware.com/utils/ghostflow-director) to prevent integration of large files, etc.

We now track issues in the [repository's GitHub Issue Tracker](https://github.com/InsightSoftwareConsortium/ITK/issues). The legacy [JIRA issue tracker](https://insightsoftwareconsortium.atlassian.net/projects/ITK/issues/ITK-3546?filter=allopenissues) is now read-only, and it will remain available for reference.

Performance Improvements
----------------------------------------

- A new, experimental `ImageRange` class provides range-based iteration over the pixels of an `itk::Image`.
- The [Rule of Five](https://en.wikipedia.org/wiki/Rule_of_three_(C%2B%2B_programming)) was applied to basic data structures like `itk::FixedArray`, `itk::Point`, `itk::Vector` so they satify `std::is_trivial` and `std::is_standard_layout`. This is now also tested. This enables compiler optimizations and moves.
- `ResampleImageFilter::CastPixelWithBoundsChecking` is now faster.
- Data copies in `itk::BSplineTransform` were reduced.
- The number of evaluations in line search optimizer were reduced by half.

Third Party Updates
------------------------------

- The Eigen linear algebra third party library is now available as an ITK module, and it is enabled by default.
- VXL was updated to require C++11 and use modern C++ syntax
- GDCM, Zlib and GIFTI were updated to the latest upstream.

Remote Modules
---------------------------

![image](https://user-images.githubusercontent.com/25432/50671606-eacd0700-0fa0-11e9-9a4b-ea94bc05f20a.png)

*The result of phase symmetry filtration of a cardiac ultrasound B-mode volume. From Hatt C. "Multi-scale Steerable Phase-Symmetry Filters for ITK."
The Insight Journal. July-December. 2011. https://hdl.handle.net/10380/3330*

New Remote Modules added:

- `PhaseSymmetry`
    - Multi-scale steerable filters for computing phase symmetry (PS).
    - From *Hatt C, "Multi-scale Steerable Phase-Symmetry Filters for ITK", https://hdl.handle.net/10380/3330*
    - https://github.com/KitwareMedical/ITKPhaseSymmetry
    - Enable in an ITK build by setting `Module_PhaseSymmetry=ON`.
    - Install Python packages: `pip install itk-phasesymmetry`
- `IOOpenSlide`
    - Read file formats supported by the OpenSlide library. These are generally TIFF-based microscopy formats.
    - https://github.com/InsightSoftwareConsortium/ITKIOOpenSlide
    - Enable in an ITK build by setting `Module_IOOpenSlide=ON`.
    - Currently requires a system installation of the OpenSlide library.
- `Montage`
    - Montaging for microscopy imaging files.
    - Based on *Bican, J., "Phase Correlation Method for ITK", https://hdl.handle.net/1926/396*, in addition to many improvements.
    - https://github.com/InsightSoftwareConsortium/ITKMontage
    - Enable in an ITK build by setting `Module_Montage=ON`.
- `BSplineGradient`
    - Approximate an image's gradient from a B-spline fit to its intensity.
    - https://github.com/InsightSoftwareConsortium/ITKBSplineGradient
    - Enable in an ITK build by setting `Module_BSplineGradient=ON`.

The `itk::JPEG2000ImageIO` class was migrated out the `ITKReview` module into its own module, `ITKIOJPEG2000`, and enabled by default.

Frequency Domain Support
----------------------------------------

- Added `itk::HalfHermitianFrequencyIterator`: iterate over images in the frequency domain generated with the `itk::RealToHalfHermitianForwardFFTImageFilter`
- Support for Fast Fourier Transforms (FFTs) computed on NVIDIA GPUs via cuFFTW: enable by setting `ITK_USE_CUFFTW=ON`.

Python
-----------

- `itk.imread` now supports reading image file series.
- [Shorthand setting of parameters of filters in `.New()` or the procedural Python interface](https://discourse.itk.org/t/itk-5-0-beta-1-pythonic-interface/1271) now supports passing tuples to set multi-valued parameters.

To install the 5.0 Beta 3 Python packages, run

```sh
python -m pip install --upgrade pip
python -m pip install --upgrade --pre itk
```

What's Next
--------------------

There are many more bug fixes and critical improvements not mentioned above. For more details, please see the change log below. Congratulations and thank you to everyone who contributed to this release.

The [ITK 5 Migration Guide](https://github.com/InsightSoftwareConsortium/ITK/blob/master/Documentation/ITK5MigrationGuide.md) is available to help transition a code base from ITK 4 to ITK 5. Please discuss your experiences on [Discourse](https://discourse.itk.org). We are approaching the 5.0.0 final release! The next release will be the first ITK 5 release candidate; it is scheduled for the end of January.

Enjoy ITK!


```
Changes from v5.0b01 to v5.0b03
-----------------------------------------------

Note: ITK v5.0b02 was skipped due to a build error with Visual Studio.

Bai Shi (1):
      COMP: To fix compilation error of "cannot dynamic_cast 'x'

Bradley Lowekamp (47):
      DOC: Improve Extract exception for region size mismatch
      BUG: Print ImageIOBase::m_Spacing
      BUG: Fix TIFFImageIO spacing for multi-page
      BUG: Support ITK transform files with corrected group names
      ENH: Only use one Work Unit in BSpline convergence checker
      BUG: Fix HDF5ImageIO reporting any HDF5 file is readable
      ENH: Improve N4BiasFieldCorrectionImageFilter
      ENH: Add extensions to HDF5ImageIO
      ENH: Add ImageIO methods to check name for file extensions
      BUG: Quiet HDF5-DIAG from H5File::isHdf5
      ENH: Update LabelStatistics to use dyanmic threading
      ENH: Move JPEG200 ImageIO into separate ImageIO module
      BUG: Update SCIOFIO to ITKv4.13 branch
      ENH: Make ProcessObject::VerifyInputInformation constant
      BUG: Handle boundary case with max metric
      PERF: Reduce number of evaluations in line search optimizer by half
      COMP: Fix unused argument warnings in SpatialObjectPoint::operator=
      BUG: Handle boundary case with max metric
      ENH: Update ImageToHistogram to use modern dynamic threading.
      PERF: implement concurrent histogram merge/reduce
      BUG: Fix move of histogram smart pointer
      BUG: Add parameter which stores the requested number of work units.
      BUG: use =default for default implementation of destructor
      BUG: Prevent square root of negative number
      BUG: Check all entries are not null
      STYLE: Prefer immediate exception over long if
      BUG: Fix sqrt of negative values
      BUG: Address valgrind leaks for classes which use ScanlineFilterCommon
      BUG: Limit number of threads used for testing ITK
      ENH: Replace centered transforms with non-centered versions
      BUG: Remove static member function variable
      DOC: Fix LBFBS2 typo
      BUG: Remove static member function variable
      BUG: Fix multi-resolution bspline registration example
      BUG: Adding updated baseline image for improved example
      DOC: Fix typos in LBFGS2 optimizer's error string
      ENH: On Azure DevOps only show test output on failure
      STYLE: Use GTest file name suffix for Google Test based tests
      BUG: Remove unused TRansfromDomainDirectionInverse IVAR
      BUG: Synchronize BSpline MeshDomain parameters from fixed params
      ENH: Adding GTest for  BSplineTransform
      ENH: Create method to set transform domain params from coeff images
      BUG: Synchronize BSpline MeshDomain parameters from fixed params
      ENH: Refactor BSplineTransform
      DOC: Update the BSplineTransform class doxygen
      ENH: Update N4BiasField to utilized named positional inputs
      COMP: Addressed unused parameter warning in ImageRegion default

Brian Helba (1) @brianhelba :
      BUG: Ensure that itkSampleToHistogramFilterTests fail on errors

Dženan Zukić (50) @dzenanz :
      ENH: code simplification and more granular progress reporting
      ENH: return bin maximum as threshold
      STYLE: removing void if used in place of empty parameter list
      ENH: update remote module MorphologicalContourInterpolation
      BUG: nbOfThreads was bounded to GlobalMaximumNumber, but not work units
      ENH: Ignore current load in PoolMultiThreader
      COMP: missing ConstPointer declaration
      BUG: fix crash in RegionGrowingBenchmark
      ENH: reducing duplication in 4 scanline-based image filters
      ENH: use scanline iterators and clean up the code a little
      COMP: fix [-Wc++11-narrowing] in initializer list during Python wrapping
      ENH: refactor ConnectedComponent to not use Barrier. Also reduce duplication.
      STYLE: aligning macro continuation backslash
      COMP: fixing unused variable warning
      COMP: add Python wrapping for ScanlineFilterCommon
      ENH: updating remotes to their latest versions
      DOC: mentioning ITKV4_COMPATIBILITY in the migration guide
      COMP: minor fixes in preparation for deprecating atomic, mutex and friends
      ENH: updating remotes to latest versions
      ENH: using standard library's mutex primitives
      ENH: deprecating functionality which exist in C++11 standard library
      COMP: missing #include <condition_variable>
      BUG: clamp work units to ITK_MAX_THREADS in Platform and Pool MultiThreaders
      BUG: fix Python wrapping after deprecating MutexLock and friends
      ENH: adding new remote modules: Montage and BSplineGradient
      DOC: fixing copy-paste error about functor type
      ENH: improve precision of median calculation by default
      STYLE: minor space and line break improvements
      ENH: FrequencyBandImageFilter derives from UnaryFrequencyDomainFilter
      ENH: ITKv5_CONST macro for VerifyPreconditions() and VerifyInputInformation()
      ENH: ITKv5_CONST macro for VerifyPreconditions() and VerifyInputInformation()
      BUG: background label could be the same as one of the object labels
      COMP: fix compiler warning in itkIndexRange.h
      ENH: adding wrapping for UnaryFrequencyDomainFilter
      DOC: updating commit information for ITKv5_CONST in ITK 4.13.x
      ENH: commit message script uses GitHub issue referencing format.
      ENH: update Montage remote module
      BUG: test image was not properly initialized. Closes #207.
      COMP: fixing compile errors on Ubuntu 16.04 with GCC 5.4.0
      ENH: compile VNL in parallel on Visual Studio
      COMP: fix compile errors with CMAKE_WINDOWS_EXPORT_ALL_SYMBOLS:BOOL=ON
      COMP: Remove VNL_EXPORT from header only class. Closes #191.
      COMP: fix CMAKE_WINDOWS_EXPORT_ALL_SYMBOLS
      COMP: fix link errors coming from undefined static constexpr member
      STYLE: rename template parameter TMatrixDimension into VDimension
      DOC: EigenValues parameter uses operator[], not operator[][]
      COMP: compile with Visual Studio in conformance mode AKA /permissive-
      COMP: moving the default constructor of vnl_matrix from .h into .hxx
      STYLE: removing empty lines between comments and constructors
      ENH: enable progress reporting with ITKV4_COMPATIBILITY. Closes #228.

Eigen Upstream (1):
      Eigen3 2018-11-19 (493fa50e)

Francois Budin (9) @fbudin69500 :
      BUG: THEADER instead of THREADER
      BUG: Disable using mkl_tbb_thread
      ENH: Adding IOOpenSlide ImageIO remote module to ITK
      BUG: WRAP_2 is a local variable, not a CACHE variable
      BUG: Wrong path to baseline images
      ENH: Allow selecting ImageIO in Python template code
      ENH: Support loading image series in itkTemplate.
      ENH: `itk.imread()` now supports image series
      ENH: Support for tuples passed as arguments through itkTemplate New() function

GDCM Upstream (2) @malaterre :
      GDCM 2018-11-05 (3ffbf1ed)
      GDCM 2018-11-30 (ec82fb48)

Gabriel A. Devenyi (1) @gdevenyi :
      PERF: Enable MINC internal compression by default

Hans Johnson (58) @hjmjohnson :
      COMP: Prefer snprintf to avoid buffer overruns
      STYLE: Use modern C++11 =delete to indicate not implemented
      ENH: Update KWStyle hash to build latest updates
      STYLE: Prefer error checked std::stoi over atoi
      BUG: GE4IO atoi failures resulted in implicit 0 image slices
      BUG: Commandline arguments were not properly processed
      BUG: atoi failure => 0 hid processing failures
      BUG: Command line parsing silently failed
      STYLE: Prefer error checked std::stod over atof
      BUG: Failed conversion to float with uncaught failure
      STYLE: Pefer = default to explicitly trivial implementations
      COMP: Use nullptr instead of 0 or NULL
      STYLE: Replace defines with constexpr and using statements
      COMP: Fix VS2017 compilation regression
      COMP: Use static method from class directly
      STYLE: Remove support for pre 20160229 VXL_VERSION_DATE_FULL
      STYLE: Decouple matlab printing explicit instantiations
      ENH: Adding explicit instantiations for dimensions 1-10
      COMP: Remove duplicate explicit instantiations
      COMP: Remove unused variables.
      BUG: vidl_itk_istream does not override an ITK object
      ENH: Use C++11 override for overridden functions.
      STYLE: Remove unnecessary vcl_XXX.h headers
      ENH: Add scripts to assist with migrations
      ENH: Adding a few more clang tidy checks.
      BUG: Do not override user selection settings
      ENH: Update to require VXL 2.0.0 or later
      STYLE: Remove unused include headers
      ENH: Provide mechanism for changing git remote url
      COMP: Many of the remotes require updates for ITKv5
      STYLE: Remove VCL_INCLUDE_CXX_0X outdated reference.
      ENH: Add specification for -D__clang__ to clang-tidy
      PERF: emplace_back method results in potentially more efficient code
      STYLE: Replace integer literals which are cast to bool.
      ENH: Fetch upstream as part of setup.
      ENH: Stop abort on first failure.
      BUG: Default commit message fixed for =delete modernization
      ENH: Provide consistency with C++11 core guidelines
      BUG: Missing default argment override
      ENH: VXL 2.0.0 provides all instantiations needed by ITK
      ENH: Fix deficient itkCastImageFilter test
      STYLE: Minor variable naming and readability changes.
      COMP: Provide conversion range testing valid_static_cast function
      ENH: Increase minimum VXL version to 2.0.1 for wrapping
      ENH: REVERT compile VNL in parallel on Visual Studio
      ENH: Require VXL v2.0.2 release.
      ENH: Increase size attribute for large third party file.
      STYLE: Remove VXL_VERSION_DATE_FULL conditionals
      COMP: Remove duplicate explicit instantiation
      ENH: Provide range for non-warned cmake versions
      ENH: Update the GIFTI codebase
      DOC: Typo: @tparam -> @param fix doxygen generation
      DOC: Improved documentation for the migration guide
      ENH: Manually update nifti version from github
      ENH: Employ the `rule of zero` for aggregate types
      STYLE: Use default member initialization
      STYLE: Remove the register keyword
      ENH: NIFTI needs to be part of ITKTargets

Hui Xie (1) @Hui-Xie :
      BUG: The Z spacing was set using thickness

Isaiah Norton (1) @ihnorton :
      BUG: don't quote argument to URL_HASH for FFTW

Jon Haitz Legarreta Gorroño (14) @jhlegarreta :
      ENH: Improve itkEuclideanDistancePointMetric coverage.
      COMP:  Use C++11 nullptr directly
      DOC: Fix incorrect class ref for Doxygen.
      ENH: Bump remote modules to their latest commits.
      ENH: Increase coverage for itk::GrayscaleFillholeFilterImage.
      DOC: Update the documentation concerning binary data.
      DOC: Format remote module documentation README to markdown.
      ENH: Update the SmoothingRecursiveYvvGaussianFilter remote module hash.
      DOC: Point to the ITK git cheat sheet in the repository.
      DOC: Fix the ITK Git cheat sheet file link.
      ENH: Add script to priviledge C++11 type alias over typedef.
      DOC: Advise users to delete the PR template in message.
      DOC: Move the issue and pull request templates to a specialized folder.
      ENH: Remove `FindITKPythonLibs.cmake` file.
      ENH: Follow remote repositories name changes.

Matthew McCormick (77) @thewtex :
      ENH: Synchronize testing data content links
      DOC: Updates and improvements on the release process
      COMP: Address empty _FILE_OFFSET_BITS in tif_config.h with MinGW64
      BUG: Do not warn about FFTW GPL license when using Intel MKL
      DOC: Improve ITK_USE_MKL description
      BUG: Mark MKL CMake configuration options as advanced
      ENH: Add support for NVidia CUDA FFTs via cuFTTW
      COMP: Fix HDF5 CMAKE_CROSSCOMPILING_EMULATOR support
      COMP: Fix HDF5 itk_h5CX_set_apl implicit declaration
      COMP: Use the Platform Threader by default with Emscripten
      COMP: Set CMP0074 to NEW
      COMP: Fix HDF5TransformIO compatibility with HDF 1.8
      COMP: Set CMP0074 in third party libraries
      COMP: Do not mark itk::FloatingPointExceptions constructor as deleted
      COMP: Define TransformBaseTemplate constructor / destructor
      COMP: DataObject InvalidRequestedRegionError unused parameter
      COMP: Remove unused orig parameters in DataObject
      BUG: Remove unused itk_minc2 imported library statement
      BUG: Skip MINC static library build when building shared libraries
      COMP: Suppress undefined public symbol warnings in third party libs
      BUG: Remove duplicate ITK version number
      COMP: Do not install HDF5 static library with BUILD_SHARED_LIBS enabled
      COMP: Add override to TransformBaseTemplate destructor
      COMP: Avoid GCC 4.8 default destructor internal compiler error
      BUG: Import zlib1.rc from ZLib subtree
      BUG: Use GlobalDefaultNumberOfThreads for FFTW plans
      BUG: Simplify specification of greatest prime factor with cuFFTW
      ENH: Add Azure Pipelines configuration
      BUG: Remove ResampleImageFilter duplicate number of pixels check
      COMP: Avoid Intel compiler warning on unknown deprecated attribute
      ENH: Ensure that .sha512 content links have LF newlines
      ENH: Configure .gitattributes for ghostflow-director CheckSize
      DOC: Update ITK Git Reference for GitHub
      DOC: Update CONTRIBUTING.md for GitHub
      COMP: Address ITKReview module wrapping following migration of ITKIOJPEG2000
      BUG: Migrate Python tests into their modules
      ENH: Use Release CMAKE_BUILD_TYPE for macOS Python CI builds
      BUG: Remove apt-get install's from macOS Azure Pipeline's configuration
      ENH: Update Git client side hooks for GitHub
      ENH: Add UploadBinaryData.sh script
      COMP: Remove vcl_complex.h from Python builds
      BUG: Remove vcl_complex support from itkTemplate.py
      BUG: Disable PythonGetNameOfClass test
      BUG: Enable ITKIOJPEG2000 by default
      DOC: Add Test a Topic to overview section
      DOC: Organize code of conduct sub-documents into a folder
      DOC: Update Documentation/Introduction.md for GitHub migration
      DOC: Fix spelling of "individual" in CONTRIBUTING.md
      DOC: Add CI status badges to the README
      COMP: Add missing mutex include to itkImageToHistogramFilter.h
      PERF: Use initializer list in ShapedImageNeighborhoodRange operator*
      DOC: Fix UploadBinaryData.sh link
      BUG: Run apt-get update for Linux Azure configuration
      COMP: Wrap InPlaceImageFilter for complex float to complex double
      BUG: Do not gpg sign third party updates
      DOC: Note that a pull request has to be explicitly opened
      DOC: Suggest using 72 characters or less in commit hooks
      ENH: Ensure NumPy is available for Python tests
      BUG: Add missing export specification for XMLReader, XMLWriterBase
      BUG: Remove invalid ShapeDetectionLevelSetFilter arguments
      COMP: Remove Doxygen \ref, \copydetails commands
      STYLE: Improve readability of HexadedronCell::EvaluatePosition.
      COMP: Fix IsFloatingPoint concept check for VariableLengthVector
      BUG: Set up wrapping options for use in modules
      ENH: Add PhaseSymmetry remote module
      ENH: Download ExternalData cache for CI builds
      DOC: Remove the convention that release branches start with "release"
      ENH: Run content link synchronization script
      ENH: Add setup-girder-api-key Git Setup script
      BUG: Remove ExternalData MD5 content link generation
      ENH: Move FreeSurfer Mesh IO into a separate module
      DOC: Add missing CONTRIBUTING.md link in UploadBinaryData.md
      ENH: Add regression test for reading legacy multi-frame DICOM
      COMP: Float narrowing conversion in BSpline class initialization
      DOC: Move maintainer documentation into Documentation/Maintenance
      DOC: Import release archive notes from the Wiki
      DOC: Improve 4.13, 5 release notes from GitHub Releases

Niels Dekker (42) @N-Dekker :
      PERF: Made ResampleImageFilter::CastPixelWithBoundsChecking faster
      STYLE: NumericTraits::NonpositiveMin() using numeric_limits::lowest()
      BUG: Fixed casts to int64_t and double in ResampleImageFilter
      ENH: Tested ResampleImageFilter preserves 'double' and int64_t pixels
      STYLE: Replaced 'bool pre = 0' by 'bool pre = false'
      STYLE: Declared "IsAt" iterator member functions 'const'
      DOC: Replaced leading stars ('*') by spaces in Doxygen code blocks
      STYLE: Replaced "Hyperrect..." by "Rect..." in class + function names
      BUG: Removed underscores from GTest test names
      STYLE: Shortened itkShapedImageNeighborhoodRangeGTest test names
      STYLE: Declared VerifyPreconditions() member functions 'const'
      STYLE: Replaced star ('*') by space in front of Doxygen \code tags
      PERF: Made ConstNeighborhoodIterator::GetPixel(i) much faster
      ENH: Added GradientNormThreshold to HoughTransform2DCirclesImageFilter
      STYLE: Removed unused ShapedImageNeighborhoodRange::m_Image
      ENH: Added ConstShapedNeighborhoodIterator::ActivateOffsets(offsets)
      DOC: Replaced leading stars ('*') by spaces in indented Doxygen code
      ENH: Added GenerateConnectedImageNeighborhoodShapeOffsets()
      COMP: Fixed GDCM OpenJPEG name mangling
      ENH: Added ShapedImageNeighborhoodRange::SetLocation(index)
      COMP: Fixed GDCM OpenJPEG name mangling
      ENH: Added HoughTransform2DCirclesImageFilter::UseImageSpacing
      ENH: Added IndexRange for efficient region and grid space iteration
      COMP: Fixed IndexRange warnings -Wshadow -Wmissing-field-initializers
      PERF: unsharpenedImage iterator in N4Bias...Filter is now "WithIndex"
      BUG: Avoid premature GaussianDerivative kernel computation HoughCircles
      BUG: ShapedImageNeighborhoodRange should not try to avoid rvalue offsets
      ENH: Added policy for constant NeighborhoodRange values outside image
      STYLE: AccessorFunctor::SetPixelAccessor parameter reference to const
      PERF: Removed 'virtual' from Default Pixel Accessor destructors
      ENH: Added ImageRange: a range of iterators to the pixels of an image
      STYLE: ImageHelper now doing '+=' and using C++11 std::integral_constant
      BUG: Fixed ShapedImageNeighborhoodRange copying pixel access parameter
      COMP: Fixed ImageRange warning, passing object to variadic constructor
      DOC: Did #136 Update migration guide with Hough transform changes
      ENH: Added default-constructor and empty() to ImageRange
      ENH: ShapedImageNeighborhoodRange now supports any buffered region index
      PERF: Defining ImageRange iterator as raw pixel pointer, when possible
      ENH: Added Experimental::MakeImageRange(TImage*)
      PERF: Replaced postfix ++ calls on ITK iterators by the prefix ++ calls
      PERF: Small improvements to equality operators of Image Region classes
      PERF: Added C++11 final, noexcept, default, initializers to ImageRegion

Pablo Hernandez-Cerdan (17) @phcerdan :
      COMP: Fix hdf5 warning missing perl script
      COMP: Fix HDF5 CMake warning policy CMP0075
      ENH: Tweak constructors, Ro5 in FixedArray, Point
      ENH: Add Ro5 to FixedArray and derived classes
      COMP: Fix warnings related to Ro5 changes in FixedArray
      ENH: Add Ro5 constructors to SymmetrySecondRankTensor
      ENH: Add Ro5 to classes derived from Point
      ENH: Initialize SecondRankTensor and RGBPixelType
      ENH: Print direction in ImageIOBase
      ENH: Add HalfHermitianFrequencyIterator
      ENH: Use variadic templates for SetPosition
      ENH: Add ThirdParty module Eigen3
      COMP: Add CONFIG to find_package(Eigen3)
      COMP: Add missing headers SymmetricEigenAnalysis
      COMP: Use the right constructors for fixed eigen3 matrix
      COMP: Reorder variables associated find_package in Eigen3
      ENH: Update external module ITKIsotropicWavelets

Roman Grothausmann (2) @romangrothausmann :
      DOC: adjusted to fit more general case n != m
      DOC: corrected description of the output

Sean McBride (3) @seanm :
      COMP: Added additional HDF5 symbols for mangling
      DOC: improved comments about HDF5 symbol mangling
      COMP: fixed some -Wunused-template warnings by adding private namespaces

Simon Rit (2) @SimonRit :
      BUG: fix NumPy bridge for itk::Image with PixelType itk::Vector
      ENH: improve automatic Python ImageFileReader for non-scalar pixel types

Tobias Wood (1) @spinicist :
      BUG: Swapped int to SizeType to prevent overflow errors

VXL Maintainers (8):
      VNL 2018-11-04 (ea3a2cc9)
      VNL 2018-11-08 (88b72533)
      VNL 2018-11-14 (ee083096)
      VNL 2018-11-15 (4fe68119)
      VNL 2018-11-18 (fa7c7abd)
      VNL 2018-11-23 (cb6f5dcb)
      VNL 2018-11-29 (f6e20c3c)
      VNL 2018-12-15 (bb0d2eb6)

Yann Le Poul (4) @YannLePoul :
      BUG: make sure the palette is empty when m_IsReadAsScalarPlusPalette is false
      DOC: fix rotation spelling issue in some versor related files
      STYLE: IsReadAsScalarPlusPalette already printed in parent class
      BUG: unnecessary call to GetExpandRGBPalette

Zlib Upstream (1):
      zlib 2018-06-11 (355d8648)

allywarner (1) @allywarner :
      BUG: CMake build errors

pierre33 (1) @pierre33 :
      ENH: Update itkNaryFunctorImageFilter
```
