/*
   igraph library.
   Copyright (C) 2003-2021 The igraph development team

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301 USA

*/

#ifndef IGRAPH_OPERATORS_SUBGRAPH_INTERNAL_H
#define IGRAPH_OPERATORS_SUBGRAPH_INTERNAL_H

#include "igraph_decls.h"
#include "igraph_datatype.h"
#include "igraph_error.h"
#include "igraph_iterators.h"

IGRAPH_BEGIN_C_DECLS

IGRAPH_PRIVATE_EXPORT igraph_error_t igraph_i_induced_subgraph_map(
    const igraph_t *graph, igraph_t *res, const igraph_vs_t vids,
    igraph_subgraph_implementation_t impl, igraph_vector_int_t *map,
    igraph_vector_int_t *invmap, igraph_bool_t map_is_prepared
);

IGRAPH_END_C_DECLS

#endif
